/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.registry.AoVEntities;

public class EntitySpellVanillaParticles
extends Entity {
    private static final DataParameter<IParticleData> PARTICLE = EntityDataManager.func_187226_a(EntitySpellVanillaParticles.class, (IDataSerializer)DataSerializers.field_198166_i);
    private static final DataParameter<Integer> RATE = EntityDataManager.func_187226_a(EntitySpellVanillaParticles.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Entity target;
    private int tick = 0;

    public EntitySpellVanillaParticles(World worldIn) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entityspellvanillaparticles.get()), worldIn);
    }

    public EntitySpellVanillaParticles(World world, Entity entity, IParticleData particle, int rate) {
        this(world);
        this.target = entity;
        this.func_70634_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        this.tick = this.field_70146_Z.nextInt(30) + 20;
        this.setParticle(particle);
        this.field_70180_af.func_187227_b(RATE, (Object)rate);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PARTICLE, (Object)ParticleTypes.field_197607_R);
        this.field_70180_af.func_187214_a(RATE, (Object)10);
    }

    public IParticleData getParticle() {
        return (IParticleData)this.field_70180_af.func_187225_a(PARTICLE);
    }

    public void setParticle(IParticleData particle) {
        this.field_70180_af.func_187227_b(PARTICLE, (Object)particle);
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
        Objects.requireNonNull(Registry.field_212632_u.func_218349_b(new ResourceLocation(compound.func_74779_i("particle")))).ifPresent(particleType -> this.field_70180_af.func_187227_b(PARTICLE, (Object)((IParticleData)particleType)));
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        compound.func_74778_a("particle", Objects.requireNonNull(this.getParticle().func_197554_b().getRegistryName()).toString());
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            for (int index = 0; index < (Integer)this.field_70180_af.func_187225_a(RATE); ++index) {
                Vec3d vec = this.func_70676_i(1.0f).func_178789_a((float)this.field_70146_Z.nextInt(360)).func_178785_b((float)this.field_70146_Z.nextInt(360));
                Vec3d pos = this.func_174791_d().func_72441_c(0.0, (double)0.65f, 0.0).func_178787_e(vec);
                this.field_70170_p.func_195594_a(this.getParticle(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.25, 0.0);
            }
            return;
        }
        if (this.tick-- <= 0 || this.target == null || !this.target.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        this.func_70634_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

