/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import tamaized.aov.network.NetworkMessages;
import tamaized.aov.registry.ParticleRegistry;

public class ClientPacketHandlerParticle
implements NetworkMessages.IMessage<ClientPacketHandlerParticle> {
    private int handlerID;
    private Vec3d pos;
    private Vec3d vel;
    private int[] data;

    public ClientPacketHandlerParticle(int id, double x, double y, double z, double dx, double dy, double dz, int ... dat) {
        this.handlerID = id;
        this.pos = new Vec3d(x, y, z);
        this.vel = new Vec3d(dx, dy, dz);
        this.data = dat;
    }

    @Override
    public void handle(PlayerEntity player) {
        ParticleRegistry.IParticleHandler handler = ParticleRegistry.getHandlerFromID(this.handlerID);
        if (handler != null) {
            handler.execute(Minecraft.func_71410_x().field_71452_i, player.field_70170_p, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, this.vel.field_72450_a, this.vel.field_72448_b, this.vel.field_72449_c, this.data);
        }
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.handlerID);
        packet.writeDouble(this.pos.field_72450_a);
        packet.writeDouble(this.pos.field_72448_b);
        packet.writeDouble(this.pos.field_72449_c);
        packet.writeDouble(this.vel.field_72450_a);
        packet.writeDouble(this.vel.field_72448_b);
        packet.writeDouble(this.vel.field_72449_c);
        packet.writeInt(this.data == null ? 0 : this.data.length);
        for (int dat : this.data) {
            packet.writeInt(dat);
        }
    }

    @Override
    public ClientPacketHandlerParticle fromBytes(PacketBuffer packet) {
        this.handlerID = packet.readInt();
        this.pos = new Vec3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
        this.vel = new Vec3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
        int size = packet.readInt();
        this.data = new int[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = packet.readInt();
        }
        return this;
    }
}

