/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.registry;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.aov.client.entity.RenderAlignmentAoE;
import tamaized.aov.client.entity.RenderCelestialOpposition;
import tamaized.aov.client.entity.RenderCombust;
import tamaized.aov.client.entity.RenderDruidicWolf;
import tamaized.aov.client.entity.RenderEarthquake;
import tamaized.aov.client.entity.RenderFlameStrike;
import tamaized.aov.client.entity.RenderGravity;
import tamaized.aov.client.entity.RenderMalefic;
import tamaized.aov.client.entity.RenderNimbusRay;
import tamaized.aov.client.entity.RenderSpellBladeBarrier;
import tamaized.aov.client.entity.RenderSpellEntity;
import tamaized.aov.client.entity.RenderSpellLightingBolt;
import tamaized.aov.client.entity.RenderSpellLightingStorm;
import tamaized.aov.common.entity.EntityAlignmentAoE;
import tamaized.aov.common.entity.EntityCelestialOpposition;
import tamaized.aov.common.entity.EntityCombust;
import tamaized.aov.common.entity.EntityDruidicWolf;
import tamaized.aov.common.entity.EntityEarthquake;
import tamaized.aov.common.entity.EntityGravity;
import tamaized.aov.common.entity.EntityMalefic;
import tamaized.aov.common.entity.EntitySpellAoVParticles;
import tamaized.aov.common.entity.EntitySpellBladeBarrier;
import tamaized.aov.common.entity.EntitySpellImplosion;
import tamaized.aov.common.entity.EntitySpellLightningBolt;
import tamaized.aov.common.entity.EntitySpellLightningStorm;
import tamaized.aov.common.entity.EntitySpellVanillaParticles;
import tamaized.aov.common.entity.ProjectileFlameStrike;
import tamaized.aov.common.entity.ProjectileNimbusRay;

@Mod.EventBusSubscriber(modid="aov", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AoVEntities {
    static final DeferredRegister<EntityType<?>> REGISTRY = new DeferredRegister(ForgeRegistries.ENTITIES, "aov");
    public static final RegistryObject<EntityType<ProjectileNimbusRay>> projectilenimbusray = AoVEntities.assign(ProjectileNimbusRay.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<ProjectileFlameStrike>> projectileflamestrike = AoVEntities.assign(ProjectileFlameStrike.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntitySpellImplosion>> entityspellimplosion = AoVEntities.assign(EntitySpellImplosion.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntitySpellBladeBarrier>> entityspellbladebarrier = AoVEntities.assign(EntitySpellBladeBarrier.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntitySpellVanillaParticles>> entityspellvanillaparticles = AoVEntities.assign(EntitySpellVanillaParticles.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntitySpellAoVParticles>> entityspellaovparticles = AoVEntities.assign(EntitySpellAoVParticles.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityMalefic>> entitymalefic = AoVEntities.assign(EntityMalefic.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityCombust>> entitycombust = AoVEntities.assign(EntityCombust.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityGravity>> entitygravity = AoVEntities.assign(EntityGravity.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityCelestialOpposition>> entitycelestialopposition = AoVEntities.assign(EntityCelestialOpposition.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntitySpellLightningBolt>> entityspelllightningbolt = AoVEntities.assign(EntitySpellLightningBolt.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityEarthquake>> entityearthquake = AoVEntities.assign(EntityEarthquake.class, 6.0f, 0.1f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntitySpellLightningStorm>> entityspelllightningstorm = AoVEntities.assign(EntitySpellLightningStorm.class, 12.0f, 0.1f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityDruidicWolf>> entitydruidicwolf = AoVEntities.assign(EntityDruidicWolf.class, 0.6f, 0.85f, 256, 1, true, EntityClassification.MISC);
    public static final RegistryObject<EntityType<EntityAlignmentAoE>> entityalignmentaoe = AoVEntities.assign(EntityAlignmentAoE.class, 0.5f, 0.5f, 256, 1, true, EntityClassification.MISC);

    public static void register(IEventBus mod) {
        REGISTRY.register(mod);
    }

    @SubscribeEvent
    public static void registerRenders(FMLClientSetupEvent e) {
        RenderingRegistry.registerEntityRenderingHandler(ProjectileNimbusRay.class, RenderNimbusRay::new);
        RenderingRegistry.registerEntityRenderingHandler(ProjectileFlameStrike.class, RenderFlameStrike::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellImplosion.class, RenderSpellEntity::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellBladeBarrier.class, RenderSpellBladeBarrier::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellAoVParticles.class, RenderSpellEntity::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellVanillaParticles.class, RenderSpellEntity::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMalefic.class, RenderMalefic::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCombust.class, RenderCombust::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGravity.class, RenderGravity::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCelestialOpposition.class, RenderCelestialOpposition::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellLightningBolt.class, RenderSpellLightingBolt::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEarthquake.class, RenderEarthquake::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellLightningStorm.class, RenderSpellLightingStorm::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDruidicWolf.class, RenderDruidicWolf::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityAlignmentAoE.class, RenderAlignmentAoE::new);
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> assign(Class<T> entity, float w, float h, int range, int freq, boolean updates, EntityClassification classification) {
        String name = entity.getSimpleName().toLowerCase();
        return REGISTRY.register(name, () -> EntityType.Builder.func_220322_a((et, world) -> {
            try {
                return (Entity)entity.getConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }, (EntityClassification)classification).setTrackingRange(range).setUpdateInterval(freq).setShouldReceiveVelocityUpdates(updates).func_220321_a(w, h).setCustomClientFactory((spawnEntity, world) -> {
            try {
                return (Entity)entity.getConstructor(World.class).newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }).func_206830_a(name));
    }
}

