/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.gui;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.modules.toolbox.tile.TileEntityToolbox;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.AWContainer;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementButtonClearAll;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementButtonCreative;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementButtonExportShaped;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementButtonExportShapeless;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementButtonLocked;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementButtonOredictLink;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementColoredQuad;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementDesignersSide;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementFluidTankSmall;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementGhostItem;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementLockedSlotIndicator;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementMageEffect;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementTabs;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.element.GuiElementToolboxSide;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.slot.ICreativeSlotClick;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.ITileEntityDesigner;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.codetaylor.mc.athenaeum.gui.ContainerBase;
import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.GuiHelper;
import com.codetaylor.mc.athenaeum.gui.Texture;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementBase;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTextureRectangle;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTitle;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AWGuiContainerBase
extends GuiContainerBase {
    protected final int textShadowColor;
    protected final TileEntityBase tileEntity;
    protected final int fluidTankOverlayColor;

    public AWGuiContainerBase(AWContainer container, ResourceLocation backgroundTexture, String titleKey, TileEntityBase tileEntity, int width, int height) {
        super((ContainerBase)container, width, height);
        TileEntityToolbox toolbox;
        this.tileEntity = tileEntity;
        EnumType tableType = tileEntity.getType();
        String tableTypeName = tableType.func_176610_l();
        this.textShadowColor = ModuleWorktablesConfig.CLIENT.getTextHighlightColor(tableTypeName);
        this.fluidTankOverlayColor = ModuleWorktablesConfig.CLIENT.getFluidTankOverlayColor(tableTypeName);
        boolean allowSlotLocking = ModuleWorktablesConfig.allowSlotLockingForTier(this.tileEntity.getTier());
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTitle((GuiContainerBase)this, titleKey, 8, 6)});
        this.addInventoryTitleElement();
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTextureRectangle((GuiContainerBase)this, new Texture(backgroundTexture, 0, 0, 256, 256), 0, 0, this.field_146999_f, this.field_147000_g)});
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            int elementY = this.field_147000_g - 95;
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonCreative(this, this.getXSize() - 18, elementY)});
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonExportShaped(this, this.getXSize() - 18 - 12, elementY)});
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonExportShapeless(this, this.getXSize() - 18 - 24, elementY)});
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonOredictLink(this, this.getXSize() - 18 - 36, elementY)});
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonClearAll(this, this.getXSize() - 18 - 48, elementY)});
        }
        if (allowSlotLocking) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementButtonLocked(this, this.getXSize() - 18, 4)});
        }
        this.addSlotBackgrounds();
        ICraftingMatrixStackHandler handler = this.tileEntity.getCraftingMatrixHandler();
        ICraftingMatrixStackHandler handlerGhost = this.tileEntity.getCraftingMatrixHandlerGhost();
        for (int y = 0; y < handler.getHeight(); ++y) {
            for (int x = 0; x < handler.getWidth(); ++x) {
                this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementGhostItem(this, this.tileEntity, handler, handlerGhost, x + y * handler.getWidth(), 20 + x * 18, 17 + y * 18, 16, 16)});
                if (!allowSlotLocking) continue;
                this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementLockedSlotIndicator(this, this.tileEntity, 20 + x * 18, 17 + y * 18)});
            }
        }
        if (tableType == EnumType.MAGE) {
            this.addMageEffectElement(container);
        }
        this.addFluidTankElement();
        ITileEntityDesigner designersTable = container.getDesignersTable();
        if (designersTable != null && container.canPlayerUsePatternSlots()) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementDesignersSide(this, designersTable, designersTable.getTexturePatternSide(), -70, 0)});
        }
        if ((toolbox = container.getToolbox()) != null && container.canPlayerUseToolbox()) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementToolboxSide(this, toolbox, toolbox.getTextureSide(), -70, () -> designersTable != null && container.canPlayerUsePatternSlots() ? 33 : 0)});
        }
        if (this.tileEntity.allowTabs()) {
            this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTabs(this, this.tileEntity, 176)});
        }
    }

    protected void addSlotBackgrounds() {
        block33: {
            int y;
            int x;
            int x2;
            String tableTypeName = this.tileEntity.getType().func_176610_l();
            Integer color = ModuleWorktablesConfig.CLIENT.getCraftingGridSlotBackgroundColor(tableTypeName);
            if (color != null) {
                if (this.tileEntity.getTier() == EnumTier.WORKSTATION) {
                    for (x2 = 0; x2 < 9; ++x2) {
                        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 8 + x2 * 18, 75, 16, 16)});
                    }
                } else if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                    for (x2 = 0; x2 < 9; ++x2) {
                        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 8 + x2 * 18, 111, 16, 16)});
                    }
                }
            }
            color = ModuleWorktablesConfig.CLIENT.getPlayerInventorySlotBackgroundColor(tableTypeName);
            int offsetY = 0;
            if (this.tileEntity.getTier() == EnumTier.WORKSTATION) {
                offsetY = 23;
            } else if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                offsetY = 59;
            }
            if (color != null) {
                for (x = 0; x < 9; ++x) {
                    for (y = 0; y < 3; ++y) {
                        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 8 + x * 18, 84 + y * 18 + offsetY, 16, 16)});
                    }
                }
                for (x = 0; x < 9; ++x) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 8 + x * 18, 142 + offsetY, 16, 16)});
                }
            }
            if ((color = ModuleWorktablesConfig.CLIENT.getCraftingGridSlotBackgroundColor(tableTypeName)) != null) {
                int size = 3;
                if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                    size = 5;
                }
                for (x = 0; x < size; ++x) {
                    for (y = 0; y < size; ++y) {
                        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 20 + x * 18, 17 + y * 18, 16, 16)});
                    }
                }
            }
            if ((color = ModuleWorktablesConfig.CLIENT.getCraftingGridSlotBackgroundColor(tableTypeName)) != null) {
                if (this.tileEntity.getTier() == EnumTier.WORKTABLE) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 78, 35, 16, 16)});
                } else if (this.tileEntity.getTier() == EnumTier.WORKSTATION) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 78, 24, 16, 16)});
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 78, 46, 16, 16)});
                } else if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 114, 40, 16, 16)});
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 114, 62, 16, 16)});
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 114, 84, 16, 16)});
                }
            }
            if ((color = ModuleWorktablesConfig.CLIENT.getFluidTankBackgroundColor(tableTypeName)) != null) {
                if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 8, 17, 6, 88)});
                } else {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 8, 17, 6, 52)});
                }
            }
            if ((color = ModuleWorktablesConfig.CLIENT.getMainOutputSlotBackgroundColor(tableTypeName)) != null) {
                if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 143, 62, 16, 16)});
                } else {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 111, 31, 24, 24)});
                }
            }
            if ((color = ModuleWorktablesConfig.CLIENT.getCraftingGridSlotBackgroundColor(tableTypeName)) == null) break block33;
            if (this.tileEntity.getTier() == EnumTier.WORKSHOP) {
                for (x2 = 0; x2 < 3; ++x2) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 116 + x2 * 18, 17, 16, 16)});
                }
            } else {
                for (int y2 = 0; y2 < 3; ++y2) {
                    this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementColoredQuad(this, color, 152, 17 + y2 * 18, 16, 16)});
                }
            }
        }
    }

    protected void addInventoryTitleElement() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementTitle((GuiContainerBase)this, "container.inventory", 8, this.field_147000_g - 93)});
    }

    protected void addMageEffectElement(AWContainer container) {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementMageEffect(this, container, 115, 35)});
    }

    protected void addFluidTankElement() {
        this.guiContainerElementAdd(new GuiElementBase[]{new GuiElementFluidTankSmall(this, this.tileEntity.getTank(), this.tileEntity.func_174877_v(), this.fluidTankOverlayColor, 8, 17)});
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void drawString(String translateKey, int x, int y) {
        FontRenderer fontRenderer = this.field_146289_q;
        if (this.tileEntity.getType() == EnumType.MAGE) {
            fontRenderer = this.field_146297_k.field_71464_q;
        }
        if (this.tileEntity.getType() == EnumType.DESIGNER) {
            String displayText = I18n.func_135052_a((String)translateKey, (Object[])new Object[0]);
            fontRenderer.func_78276_b(displayText, x - 1, y, Color.WHITE.getRGB());
        } else {
            GuiHelper.drawStringOutlined((String)translateKey, (int)x, (int)y, (FontRenderer)fontRenderer, (int)this.textShadowColor);
        }
    }

    public TileEntityBase getTileEntity() {
        return this.tileEntity;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        Slot slot = this.getSlotUnderMouse();
        if (!(slot instanceof ICreativeSlotClick) || !((ICreativeSlotClick)slot).allowOredict()) {
            super.func_146285_a(stack, x, y);
            return;
        }
        Item item = stack.func_77973_b();
        ResourceLocation resourceLocation = item.getRegistryName();
        if (this.tileEntity.isCreative() && resourceLocation != null) {
            FontRenderer font = item.getFontRenderer(stack);
            GuiUtils.preItemToolTip((ItemStack)stack);
            int slotNumber = slot.field_75222_d;
            String lookup = (String)this.tileEntity.oreDictMap.func_76041_a(slotNumber);
            ArrayList<String> lines = new ArrayList<String>();
            String suffix = String.format("(#%04d/%d)", Item.func_150891_b((Item)item), stack.func_77952_i());
            lines.add(stack.func_77953_t().field_77937_e + stack.func_82833_r() + " " + suffix);
            lines.add(TextFormatting.DARK_GRAY + resourceLocation.func_110624_b() + ":" + resourceLocation.func_110623_a());
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
            if (oreIDs.length > 0) {
                lines.add("");
                lines.add(I18n.func_135052_a((String)"item.artisanworktables.tooltip.creative.table.oredict.header", (Object[])new Object[]{TextFormatting.DARK_GRAY}));
                if (lookup == null) {
                    lines.add("  " + TextFormatting.GOLD + I18n.func_135052_a((String)"item.artisanworktables.tooltip.creative.table.oredict.none", (Object[])new Object[0]));
                } else {
                    lines.add("  " + I18n.func_135052_a((String)"item.artisanworktables.tooltip.creative.table.oredict.none", (Object[])new Object[0]));
                }
                for (int oreID : oreIDs) {
                    String oreName = OreDictionary.getOreName((int)oreID);
                    if (lookup != null && lookup.equals(oreName)) {
                        lines.add("  " + TextFormatting.GOLD + oreName);
                        continue;
                    }
                    lines.add("  " + oreName);
                }
            }
            this.drawHoveringText(lines, x, y, font == null ? this.field_146289_q : font);
            GuiUtils.postItemToolTip();
        } else {
            super.func_146285_a(stack, x, y);
        }
    }
}

