/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeBuilderException;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementBuilder;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanIngredient;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanItemStack;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTArtisanRecipeFactory;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.IZenRecipeBuilder;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.copy.IZenRecipeBuilderCopyStrategy;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.copy.ZenRecipeBuilderCopyStrategy;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.RecipeBuilderInternal;
import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTInputHelper;
import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTLogHelper;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import java.util.ArrayList;

public class ZenRecipeBuilder
implements IZenRecipeBuilder {
    private RecipeBuilderInternal recipeBuilder;

    ZenRecipeBuilder(String tableName) throws RecipeBuilderException {
        this.recipeBuilder = RecipeBuilderInternal.get(tableName, new CTArtisanRecipeFactory());
    }

    @Override
    public IZenRecipeBuilder setName(String recipeName) {
        try {
            this.recipeBuilder.setName(recipeName);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setShaped(IIngredient[][] ingredients) {
        IIngredient[][] iIngredientArray = ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] ingredientArray;
            for (IIngredient ingredient : ingredientArray = iIngredientArray[i]) {
                if (!(ingredient instanceof ILiquidStack)) continue;
                return this.logError("Liquids are not supported in ingredients");
            }
        }
        try {
            this.recipeBuilder.setIngredients(CTArtisanIngredient.fromMatrix(ingredients));
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setMirrored(boolean mirrored) {
        this.recipeBuilder.setMirrored(mirrored);
        return this;
    }

    @Override
    public IZenRecipeBuilder setShapeless(IIngredient[] ingredients) {
        for (IIngredient ingredient : ingredients) {
            if (!(ingredient instanceof ILiquidStack)) continue;
            return this.logError("Liquids are not supported in ingredients");
        }
        try {
            this.recipeBuilder.setIngredients(CTArtisanIngredient.fromArray(ingredients));
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setFluid(ILiquidStack fluidIngredient) {
        try {
            this.recipeBuilder.setFluidIngredient(CTInputHelper.toFluid((ILiquidStack)fluidIngredient));
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setSecondaryIngredients(IIngredient[] ingredients) {
        if (ingredients == null || ingredients.length == 0) {
            return this.logError("Secondary ingredients parameter can't be null or zero length");
        }
        ArrayList<IIngredient> adjustedList = new ArrayList<IIngredient>();
        for (IIngredient ingredient : ingredients) {
            if (ingredient instanceof ILiquidStack) {
                return this.logError("Liquids are not supported in secondary ingredients");
            }
            if (ingredient == null) continue;
            adjustedList.add(ingredient);
        }
        try {
            this.recipeBuilder.setSecondaryIngredients(CTArtisanIngredient.fromArray(adjustedList.toArray(new IIngredient[adjustedList.size()])));
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setConsumeSecondaryIngredients(boolean consumeSecondaryIngredients) {
        this.recipeBuilder.setConsumeSecondaryIngredients(consumeSecondaryIngredients);
        return this;
    }

    @Override
    public IZenRecipeBuilder addTool(IIngredient tool, int damage) {
        if (tool instanceof ILiquidStack) {
            return this.logError("Tools can't be liquids");
        }
        try {
            this.recipeBuilder.addTool(CTArtisanIngredient.from(tool), damage);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder addOutput(IItemStack output, int weight) {
        if (weight <= 0) {
            weight = 1;
        }
        try {
            this.recipeBuilder.addOutput(CTArtisanItemStack.from(output), weight);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setExtraOutputOne(IItemStack output, float chance) {
        try {
            this.recipeBuilder.setExtraOutput(0, CTArtisanItemStack.from(output), chance);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setExtraOutputTwo(IItemStack output, float chance) {
        try {
            this.recipeBuilder.setExtraOutput(1, CTArtisanItemStack.from(output), chance);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setExtraOutputThree(IItemStack output, float chance) {
        try {
            this.recipeBuilder.setExtraOutput(2, CTArtisanItemStack.from(output), chance);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setMinimumTier(int minimumTier) {
        try {
            this.recipeBuilder.setMinimumTier(minimumTier);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setMaximumTier(int maximumTier) {
        try {
            this.recipeBuilder.setMaximumTier(maximumTier);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setExperienceRequired(int experienceRequired) {
        try {
            this.recipeBuilder.setExperienceRequired(experienceRequired);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setLevelRequired(int levelRequired) {
        try {
            this.recipeBuilder.setLevelRequired(levelRequired);
        }
        catch (RecipeBuilderException e) {
            return this.logError(e.getMessage());
        }
        return this;
    }

    @Override
    public IZenRecipeBuilder setConsumeExperience(boolean consumeExperience) {
        this.recipeBuilder.setConsumeExperience(consumeExperience);
        return this;
    }

    @Override
    public IZenRecipeBuilder setHidden(boolean hidden) {
        this.recipeBuilder.setHidden(hidden);
        return this;
    }

    @Override
    public IZenRecipeBuilder setRecipeFunction(IRecipeFunction recipeFunction) {
        CTArtisanRecipeFactory recipeFactory = (CTArtisanRecipeFactory)this.recipeBuilder.getRecipeFactory();
        recipeFactory.setRecipeFunction(recipeFunction);
        return this;
    }

    @Override
    public IZenRecipeBuilder setRecipeAction(IRecipeAction recipeAction) {
        CTArtisanRecipeFactory recipeFactory = (CTArtisanRecipeFactory)this.recipeBuilder.getRecipeFactory();
        recipeFactory.setRecipeAction(recipeAction);
        return this;
    }

    @Override
    public IZenRecipeBuilder setCopy(IZenRecipeBuilderCopyStrategy copyStrategy) {
        ZenRecipeBuilderCopyStrategy strategy = (ZenRecipeBuilderCopyStrategy)copyStrategy;
        this.recipeBuilder.setCopy(strategy.getStrategy());
        return this;
    }

    @Override
    public IZenRecipeBuilder addRequirement(IRequirementBuilder builder) {
        this.recipeBuilder.addRequirement(builder);
        return this;
    }

    @Override
    public IZenRecipeBuilder create() {
        try {
            this.recipeBuilder.create();
        }
        catch (RecipeBuilderException e) {
            this.logError("Failed to create recipe");
            this.logError(e.getMessage());
        }
        this.recipeBuilder = new RecipeBuilderInternal(this.recipeBuilder.getTableName(), this.recipeBuilder.getRecipeAdditionQueue(), new CTArtisanRecipeFactory());
        return this;
    }

    private IZenRecipeBuilder logError(String message) {
        CTLogHelper.logErrorFromZenMethod((String)message);
        return this;
    }
}

