/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.network;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktables;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.SCPacketWorktableFluidUpdate;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntitySecondaryInputBase;
import com.codetaylor.mc.athenaeum.spi.packet.SPacketTileEntityBase;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CSPacketWorktableClear
extends SPacketTileEntityBase<CSPacketWorktableClear> {
    public static final int CLEAR_FLUID = 1;
    public static final int CLEAR_GRID = 2;
    public static final int CLEAR_TOOLS = 4;
    public static final int CLEAR_OUTPUT = 8;
    public static final int CLEAR_EXTRA_OUTPUT = 16;
    public static final int CLEAR_SECONDARY_INPUT = 32;
    public static final int CLEAR_ALL = 63;
    private int clearFlags;

    public CSPacketWorktableClear() {
    }

    public CSPacketWorktableClear(BlockPos blockPos, int clearFlags) {
        super(blockPos);
        this.clearFlags = clearFlags;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.clearFlags);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.clearFlags = buf.readInt();
    }

    public IMessage onMessage(CSPacketWorktableClear message, MessageContext ctx, TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityBase) {
            TileEntityBase table = (TileEntityBase)tileEntity;
            CSPacketWorktableClear.clear(table, message.clearFlags);
            BlockHelper.notifyBlockUpdate((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        }
        return null;
    }

    public static void clear(TileEntityBase table, int clearFlags) {
        int i;
        if ((clearFlags & 1) == 1) {
            FluidTank tank = table.getTank();
            tank.drain(tank.getCapacity(), true);
            ModuleWorktables.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketWorktableFluidUpdate(table.func_174877_v(), tank), (TileEntity)table);
        }
        if ((clearFlags & 2) == 2) {
            ICraftingMatrixStackHandler craftingMatrixHandler = table.getCraftingMatrixHandler();
            for (i = 0; i < craftingMatrixHandler.getSlots(); ++i) {
                craftingMatrixHandler.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        if ((clearFlags & 8) == 8) {
            ItemStackHandler resultHandler = table.getResultHandler();
            resultHandler.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if ((clearFlags & 4) == 4) {
            ItemStackHandler toolHandler = table.getToolHandler();
            for (i = 0; i < toolHandler.getSlots(); ++i) {
                toolHandler.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        if ((clearFlags & 0x10) == 16) {
            ItemStackHandler secondaryOutputHandler = table.getSecondaryOutputHandler();
            for (i = 0; i < secondaryOutputHandler.getSlots(); ++i) {
                secondaryOutputHandler.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
        if (table instanceof TileEntitySecondaryInputBase && (clearFlags & 0x20) == 32) {
            IItemHandlerModifiable secondaryIngredientHandler = ((TileEntitySecondaryInputBase)table).getSecondaryIngredientHandler();
            for (i = 0; i < secondaryIngredientHandler.getSlots(); ++i) {
                secondaryIngredientHandler.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }
}

