/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.recipe;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanItemStack;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ISecondaryIngredientMatcher;
import java.util.Collection;
import java.util.List;

public class SecondaryIngredientMatcher
implements ISecondaryIngredientMatcher {
    private final int[] availableAmounts;
    private final List<IArtisanItemStack> inputs;

    public SecondaryIngredientMatcher(List<IArtisanItemStack> inputs) {
        this.inputs = inputs;
        this.availableAmounts = new int[this.inputs.size()];
    }

    @Override
    public boolean matches(Collection<IArtisanIngredient> requiredIngredients) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            IArtisanItemStack iItemStack = this.inputs.get(i);
            this.availableAmounts[i] = iItemStack != null ? iItemStack.getAmount() : 0;
        }
        for (IArtisanIngredient recipeInput : requiredIngredients) {
            int amountRequired = recipeInput.getAmount();
            for (int i = 0; i < this.inputs.size(); ++i) {
                IArtisanItemStack input = this.inputs.get(i);
                if (input == null || !recipeInput.matchesIgnoreAmount(input)) continue;
                if (this.availableAmounts[i] >= amountRequired) {
                    int n = i;
                    this.availableAmounts[n] = this.availableAmounts[n] - amountRequired;
                    amountRequired = 0;
                    break;
                }
                amountRequired -= this.availableAmounts[i];
                this.availableAmounts[i] = 0;
            }
            if (amountRequired <= 0) continue;
            return false;
        }
        return true;
    }
}

