/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.api.materials;

import com.google.common.collect.HashBiMap;
import com.teamacronymcoders.base.api.materials.MaterialType;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;

public class MaterialRegistry {
    private static HashBiMap<Integer, MaterialType> MATERIALS = HashBiMap.create();

    public static boolean registerMaterial(int ID, MaterialType materialType) {
        if (MaterialRegistry.getMaterials().containsKey((Object)materialType.getName())) {
            return false;
        }
        MaterialRegistry.getMaterials().put((Object)ID, (Object)materialType);
        return true;
    }

    public static boolean unregisterMaterial(String key) {
        MutablePair pair = new MutablePair((Object)key, (Object)MaterialRegistry.getIDFromName(key));
        if (!MaterialRegistry.getMaterials().keySet().contains(pair)) {
            return false;
        }
        MaterialRegistry.getMaterials().remove((Object)pair);
        return true;
    }

    public static boolean isRegistered(String key) {
        return MaterialRegistry.getMaterials().containsKey((Object)key);
    }

    public static HashBiMap<Integer, MaterialType> getMaterials() {
        return MATERIALS;
    }

    public static MaterialType getFromID(int id) {
        return (MaterialType)MaterialRegistry.getMaterials().get((Object)id);
    }

    public static MaterialType getFromName(String name) {
        for (Map.Entry ent : MaterialRegistry.getMaterials().entrySet()) {
            if (!((MaterialType)ent.getValue()).getName().equalsIgnoreCase(name)) continue;
            return (MaterialType)ent.getValue();
        }
        return null;
    }

    public static int getIDFromName(String name) {
        for (Map.Entry ent : MaterialRegistry.getMaterials().entrySet()) {
            if (!((MaterialType)ent.getValue()).getName().equalsIgnoreCase(name)) continue;
            return (Integer)ent.getKey();
        }
        return -1;
    }

    public static int getIDFromMaterial(MaterialType mat) {
        return (Integer)MaterialRegistry.getMaterials().inverse().get((Object)mat);
    }

    public static LinkedList<Integer> getIDList() {
        return new LinkedList<Integer>(MaterialRegistry.getMaterials().keySet());
    }
}

