/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models;

import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.blocks.IHasBlockStateMapper;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.client.models.wrapped.WrappedBlockEntry;
import com.teamacronymcoders.base.items.IHasItemColor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class SafeModelLoader {
    private IBaseMod mod;

    public SafeModelLoader(IBaseMod mod) {
        this.mod = mod;
    }

    public void setBlockModel(Block block) {
        this.setBlockModel(block, 0);
    }

    public void setBlockModel(Block block, int metadata) {
        this.setBlockModel(block, metadata, block.func_149739_a());
    }

    public void setBlockModel(Block block, int metadata, String override) {
        this.setItemModel(Item.func_150898_a((Block)block), metadata, override);
    }

    public void setItemModel(Item item) {
        this.setItemModel(item, 0);
    }

    public void setItemModel(Item item, int metadata) {
        if (item != null) {
            String name = item.func_77658_a();
            if (name.startsWith("item.") || name.startsWith("tile.")) {
                name = name.substring(5);
            }
            this.setItemModel(item, metadata, name);
        }
    }

    public void setItemModel(Item item, int metadata, String override) {
        this.setItemModel(item, metadata, new ResourceLocation(this.mod.getID(), override));
    }

    public void setItemModel(Item item, int metadata, ResourceLocation resourceLocation) {
        this.mod.getLibProxy().setItemModel(item, metadata, resourceLocation);
    }

    public void setItemModel(Object object, int metadata, String location) {
        Item item = null;
        if (object instanceof Item) {
            item = (Item)object;
        } else if (object instanceof Block) {
            item = Item.func_150898_a((Block)((Block)object));
        }
        if (item != null) {
            this.setItemModel(item, metadata, new ResourceLocation(this.mod.getID(), location));
        }
    }

    public void setAllItemModels(Item item, IHasModel model) {
        this.mod.getLibProxy().setAllItemModels(item, model);
    }

    public void registerFluidModel(Block fluidBlock, ResourceLocation resourceLocation) {
        this.mod.getLibProxy().registerFluidModel(fluidBlock, resourceLocation);
    }

    public void registerItemColor(Item item, IHasItemColor itemColor) {
        this.mod.getLibProxy().registerItemColor(item, itemColor);
    }

    public void registerItemColor(Block block, IHasItemColor itemColor) {
        this.mod.getLibProxy().registerItemColor(block, itemColor);
    }

    public void registerBlockColor(IHasBlockColor blockColor) {
        this.mod.getLibProxy().registerBlockColor(blockColor);
    }

    public void registerBlockStateMapper(Block block, IHasBlockStateMapper stateMapper) {
        this.mod.getLibProxy().registerBlockStateMapper(block, stateMapper);
    }

    public void registerModelVariant(Item item, ResourceLocation resourceLocation) {
        this.mod.getLibProxy().registerModelVariant(item, resourceLocation);
    }

    public void registerWrappedModel(ResourceLocation resourceLocation, WrappedBlockEntry wrappedBlockEntry) {
        this.mod.getLibProxy().registerWrappedModel(resourceLocation, wrappedBlockEntry);
    }
}

