/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.blocksided;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.teamacronymcoders.base.blocks.properties.SideType;
import com.teamacronymcoders.base.client.models.ModelUtils;
import com.teamacronymcoders.base.client.models.blocksided.BakedModelBlockSided;
import com.teamacronymcoders.base.client.models.blocksided.ITextureNamer;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelBlockSided
implements IRetexturableModel {
    final String name;
    final String modid;
    final String type;
    ImmutableMap<String, ResourceLocation> textures;

    public ModelBlockSided(String modid, String name, String type, ImmutableMap<String, ResourceLocation> textures) {
        this.name = name;
        this.modid = modid;
        this.type = type;
        this.textures = textures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures.values();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite[][] tex = new TextureAtlasSprite[6][3];
        for (EnumFacing f : EnumFacing.field_82609_l) {
            for (SideType cfg : SideType.values()) {
                ResourceLocation rl = (ResourceLocation)this.textures.get((Object)(f.func_176610_l() + "_" + cfg.func_176610_l()));
                if (rl == null) continue;
                tex[f.ordinal()][cfg.ordinal()] = ModelUtils.getBlockSprite(rl);
            }
        }
        return new BakedModelBlockSided(this.modid, this.name, tex);
    }

    public IModelState getDefaultState() {
        return null;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        String newName = this.name;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            for (SideType cfg : SideType.values()) {
                ITextureNamer namer;
                String key = f.func_176610_l() + "_" + cfg.func_176610_l();
                ResourceLocation rl = (ResourceLocation)this.textures.get((Object)key);
                if (textures.containsKey((Object)key)) {
                    rl = new ResourceLocation((String)textures.get((Object)key));
                } else if (textures.containsKey((Object)f.func_176610_l())) {
                    String c;
                    namer = BakedModelBlockSided.TYPES.get(this.type);
                    rl = new ResourceLocation((String)textures.get((Object)f.func_176610_l()));
                    if (namer != null && (c = namer.nameFromCfg(f, cfg)) != null) {
                        rl = new ResourceLocation((String)textures.get((Object)f.func_176610_l()) + "_" + c);
                    }
                } else if (textures.containsKey((Object)"name")) {
                    namer = BakedModelBlockSided.TYPES.get(this.type);
                    newName = (String)textures.get((Object)"name");
                    if (namer != null) {
                        rl = new ResourceLocation(newName + "_" + namer.getTextureName(f, cfg));
                    }
                }
                builder.put((Object)key, (Object)rl);
            }
        }
        return new ModelBlockSided(this.modid, newName, this.type, (ImmutableMap<String, ResourceLocation>)builder.build());
    }
}

