/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.wrapped;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.client.models.ModelUtils;
import com.teamacronymcoders.base.client.models.wrapped.WrappedBlockEntry;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WrappedBakedModel
implements IBakedModel {
    private WrappedBlockEntry blockEntry;
    private List<BakedQuad> bakedQuads = null;
    private TextureAtlasSprite particleTexture;

    public WrappedBakedModel(WrappedBlockEntry wrappedBlockEntry) {
        this.blockEntry = wrappedBlockEntry;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (this.bakedQuads == null) {
            this.bakedQuads = Lists.newArrayList();
            this.bakedQuads.addAll(ModelUtils.bakeQuads(this.blockEntry.getBaseResource(), null));
            for (Map.Entry<ResourceLocation, Boolean> location : this.blockEntry.getLayers().entrySet()) {
                Color color = location.getValue() != false ? this.blockEntry.getColor() : null;
                this.bakedQuads.addAll(ModelUtils.bakeQuads(location.getKey(), color));
            }
        }
        return this.bakedQuads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        if (this.particleTexture == null) {
            this.particleTexture = ModelUtils.getBlockSprite(this.blockEntry.getBaseResource());
        }
        return this.particleTexture;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ModelUtils.getDefaultTransforms();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

