/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.wrapped;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.wrapped.WrappedBlockEntry;
import com.teamacronymcoders.base.client.models.wrapped.WrappedModel;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WrappedModelLoader
implements ICustomModelLoader {
    private static WrappedModelLoader instance;
    private Map<ResourceLocation, WrappedBlockEntry> models = Maps.newHashMap();
    private List<String> modids = Lists.newArrayList();

    public static WrappedModelLoader getInstance() {
        if (instance == null) {
            instance = new WrappedModelLoader();
        }
        return instance;
    }

    public WrappedModelLoader() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this);
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.modids.contains(modelLocation.func_110624_b()) && this.models.containsKey(this.ensureNotModel(modelLocation));
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return new WrappedModel(this.models.get(this.ensureNotModel(modelLocation)));
    }

    private ResourceLocation ensureNotModel(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
    }

    public static void addModel(ResourceLocation resourceLocation, WrappedBlockEntry wrappedBlockEntry) {
        if (!WrappedModelLoader.getInstance().modids.contains(resourceLocation.func_110624_b())) {
            WrappedModelLoader.getInstance().modids.add(resourceLocation.func_110624_b());
        }
        WrappedModelLoader.getInstance().models.put(resourceLocation, wrappedBlockEntry);
    }
}

