/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.commands;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandBase
implements ICommand {
    private String name;
    private String usage;
    private List<String> aliases;
    private int permissionLevel;
    private Map<String, ICommand> subCommands;

    public CommandBase(String name) {
        this(name, "", Lists.newArrayList(), 0, Lists.newArrayList());
    }

    public CommandBase(String name, String usage, List<String> aliases, int permissionLevel, List<ICommand> commands) {
        this.name = name;
        this.usage = usage;
        this.aliases = aliases;
        this.permissionLevel = permissionLevel;
        this.subCommands = new HashMap<String, ICommand>();
        commands.forEach(command -> this.subCommands.put(command.func_71517_b(), (ICommand)command));
    }

    @Nonnull
    public String func_71517_b() {
        return this.name;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return this.usage;
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        boolean[] goodToGood = new boolean[]{true};
        this.subCommands.forEach((name, subCommand) -> {
            goodToGood[0] = goodToGood[0] & subCommand.func_184882_a(server, sender);
        });
        return goodToGood[0] && sender.func_70003_b(this.permissionLevel, this.func_71517_b());
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos pos) {
        if (this.subCommands.get(args[0]) != null) {
            return this.subCommands.get(args[0]).func_184883_a(server, sender, args, pos);
        }
        return Lists.newArrayList();
    }

    public boolean func_82358_a(@Nonnull String[] args, int index) {
        return false;
    }

    public int compareTo(@Nonnull ICommand otherCommand) {
        return this.func_71517_b().compareTo(otherCommand.func_71517_b());
    }
}

