/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.creativetabs.CreativeTabCarousel;
import com.teamacronymcoders.base.materialsystem.MaterialException;
import com.teamacronymcoders.base.materialsystem.compat.MaterialCompatLoader;
import com.teamacronymcoders.base.materialsystem.items.ItemMaterialPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPartSave;
import com.teamacronymcoders.base.materialsystem.materialparts.MissingMaterialPart;
import com.teamacronymcoders.base.materialsystem.materials.Material;
import com.teamacronymcoders.base.materialsystem.materials.MaterialBuilder;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.materialsystem.parts.PartBuilder;
import com.teamacronymcoders.base.materialsystem.parts.ProvidedParts;
import com.teamacronymcoders.base.materialsystem.parttype.PartType;
import com.teamacronymcoders.base.registry.ItemRegistry;
import com.teamacronymcoders.base.savesystem.SaveLoader;
import com.teamacronymcoders.base.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class MaterialSystem {
    public static MissingMaterialPart MISSING_MATERIAL_PART;
    private IBaseMod mod;
    private Map<String, Part> partMap = new HashMap<String, Part>();
    private Map<String, Material> materialMap = new HashMap<String, Material>();
    private Map<String, PartType> partTypeMap = new HashMap<String, PartType>();
    private BiMap<Integer, MaterialPart> materialPartBiMap = HashBiMap.create();
    private Map<String, Integer> nameMapping = Maps.newHashMap();
    private int nextId = 0;
    public ItemMaterialPart itemMaterialPart;
    public CreativeTabCarousel materialCreativeTab;
    public List<MaterialBuilder> materialsNotBuilt = Lists.newArrayList();
    public List<PartBuilder> partsNotBuilt = Lists.newArrayList();

    public MaterialSystem(IBaseMod mod) {
        this.mod = mod;
    }

    public void setup(ASMDataTable dataTable) {
        MaterialCompatLoader materialCompatLoader = new MaterialCompatLoader();
        materialCompatLoader.loadCompat(dataTable);
        this.nameMapping.putAll(SaveLoader.getSavedObject("material_parts_" + this.mod.getID(), MaterialPartSave.class).getMaterialMappings());
        this.nameMapping.values().forEach(id -> {
            if (id > this.nextId) {
                this.nextId = id + 1;
            }
        });
        this.materialCreativeTab = new CreativeTabCarousel("materials." + this.mod.getID());
        this.setupItem();
        try {
            MISSING_MATERIAL_PART = new MissingMaterialPart(this.getMod(), this);
        }
        catch (MaterialException e) {
            this.mod.getLogger().fatal("Failed to Create Missing Material Part, THIS IS BAD");
        }
        if (this.mod.getSubBlockSystem() != null) {
            ProvidedParts providedParts = new ProvidedParts(this.mod, this, this.mod.getSubBlockSystem());
            providedParts.initPartsAndTypes();
            materialCompatLoader.doCompat(this);
        } else {
            this.mod.getLogger().fatal("Failed to find subBlockSystem");
        }
    }

    public void setupItem(MaterialPart materialPart) {
        this.setupItem();
        this.itemMaterialPart.addMaterialPart((Integer)this.materialPartBiMap.inverse().get((Object)materialPart), materialPart);
    }

    public void setupItem() {
        if (this.itemMaterialPart == null) {
            this.itemMaterialPart = new ItemMaterialPart(this);
            this.itemMaterialPart.func_77637_a(this.materialCreativeTab);
            this.mod.getRegistryHolder().getRegistry(ItemRegistry.class, "ITEM").register(this.itemMaterialPart);
        }
    }

    public void finishUp() {
        ArrayList parts = Lists.newArrayList((Iterable)this.materialPartBiMap.values());
        for (MaterialPart materialPart : parts) {
            materialPart.setup();
        }
        MaterialPartSave save = new MaterialPartSave();
        save.setMaterialMappings((Map<Integer, MaterialPart>)this.materialPartBiMap);
        SaveLoader.saveObject("material_parts_" + this.mod.getID(), save);
    }

    public void registerPart(Part part) {
        this.partMap.put(TextUtils.toSnakeCase(part.getName()), part);
    }

    public void registerPartType(PartType partType) {
        this.partTypeMap.put(partType.getName(), partType);
    }

    public void registerMaterial(Material material) {
        this.materialMap.put(material.getName(), material);
    }

    public Part getPart(String name) {
        return this.partMap.get(name);
    }

    public PartType getPartType(String name) {
        return this.partTypeMap.get(name);
    }

    public Material getMaterial(String name) {
        return this.materialMap.get(name);
    }

    public int getMaterialPartId(MaterialPart materialPart) {
        return (Integer)this.materialPartBiMap.inverse().get((Object)materialPart);
    }

    public MaterialPart getMaterialPart(int itemDamage) {
        return (MaterialPart)this.materialPartBiMap.get((Object)itemDamage);
    }

    public Map<Integer, MaterialPart> getMaterialParts() {
        return this.materialPartBiMap;
    }

    public List<MaterialPart> registerPartsForMaterial(Material material, String ... partNames) throws MaterialException {
        ArrayList materialParts = Lists.newArrayList();
        for (String partName : partNames) {
            Part part = this.partMap.get(partName.toLowerCase(Locale.US));
            if (part == null) {
                throw new MaterialException("Could not find part with name: " + partName);
            }
            MaterialPart materialPart = new MaterialPart(this, material, part);
            this.registerMaterialPart(materialPart);
            materialParts.add(materialPart);
        }
        return materialParts;
    }

    public void registerMaterialPart(MaterialPart materialPart) {
        int id = this.nextId++;
        if (this.nameMapping.containsKey(materialPart.getUnlocalizedName())) {
            id = this.nameMapping.get(materialPart.getUnlocalizedName());
        }
        this.materialPartBiMap.put((Object)id, (Object)materialPart);
    }

    public IBaseMod getMod() {
        return this.mod;
    }
}

