/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.blocks;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.blocks.SubBlockPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPartData;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SubBlockOrePart
extends SubBlockPart {
    private ItemStack itemStackToDrop = null;
    private String itemDrop;
    private IBaseMod mod;
    private ResourceLocation variantLocation;

    public SubBlockOrePart(MaterialPart materialPart, ResourceLocation variantLocation, MaterialSystem materialSystem) {
        super(materialPart, materialSystem.materialCreativeTab);
        MaterialPartData data = materialPart.getData();
        this.mod = materialSystem.getMod();
        if (data.containsDataPiece("drop")) {
            this.itemDrop = data.getDataPiece("drop");
        }
        this.variantLocation = variantLocation;
    }

    @Override
    public void getDrops(int fortune, List<ItemStack> itemStacks) {
        if (this.itemStackToDrop == null) {
            if (this.itemDrop != null && !this.itemDrop.isEmpty()) {
                Item item;
                String[] itemDropArray = this.itemDrop.split(":");
                String itemString = itemDropArray[0];
                int meta = 0;
                if (itemDropArray.length > 1) {
                    itemString = itemString + itemDropArray[1];
                    if (itemDropArray.length > 2) {
                        meta = Integer.parseInt(itemDropArray[2]);
                    }
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemString))) != null) {
                    this.itemStackToDrop = new ItemStack(item, 1, meta);
                } else {
                    this.mod.getLogger().error("Could not find Item for name: " + itemString);
                }
            } else {
                this.itemStackToDrop = this.itemStack;
            }
        }
        if (this.itemStackToDrop != null) {
            itemStacks.add(this.itemStackToDrop.func_77946_l());
        } else {
            this.mod.getLogger().fatal("Couldn't drop null ItemStack for " + this.getMaterialPart().getLocalizedName());
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation(this.mod.getID(), "materials/" + this.getUnLocalizedName());
    }

    @Override
    public IGeneratedModel getGeneratedModel() {
        TemplateFile templateFile = TemplateManager.getTemplateFile("ore_block_state");
        HashMap replacements = Maps.newHashMap();
        String unlocalizedName = this.getMaterialPart().getPart().getUnlocalizedName();
        String variantTexture = new ResourceLocation(this.variantLocation.func_110624_b(), "blocks/" + this.variantLocation.func_110623_a()).toString();
        replacements.put("texture", variantTexture);
        replacements.put("particle", variantTexture);
        replacements.put("ore_shadow", "base:blocks/" + unlocalizedName + "_shadow");
        replacements.put("ore", "base:blocks/" + unlocalizedName);
        templateFile.replaceContents(replacements);
        return new GeneratedModel("materials/" + this.getMaterialPart().getUnlocalizedName(), ModelType.BLOCKSTATE, templateFile.getFileContents());
    }
}

