/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.materialparts;

import com.teamacronymcoders.base.materialsystem.MaterialException;
import com.teamacronymcoders.base.materialsystem.parts.PartDataPiece;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MaterialPartData {
    private Map<String, String> data = new HashMap<String, String>();
    private List<PartDataPiece> dataPieces;

    public MaterialPartData(List<PartDataPiece> dataPieces) {
        this.dataPieces = dataPieces;
    }

    public String getDataPiece(String name) {
        return this.data.get(name.toLowerCase(Locale.US));
    }

    public boolean containsDataPiece(String name) {
        return this.data.containsKey(name.toLowerCase(Locale.US));
    }

    public void addDataValue(String name, String value) {
        this.data.put(name.toLowerCase(Locale.US), value);
    }

    public void validate() throws MaterialException {
        for (PartDataPiece dataPiece : this.dataPieces) {
            if (!dataPiece.isRequired() || this.data.containsKey(dataPiece.getName())) continue;
            throw new MaterialException("Missing required data piece: " + dataPiece.getName());
        }
        for (String dataName : this.data.keySet()) {
            boolean hasDataPiece = false;
            Iterator<PartDataPiece> dataPiecesIterable = this.dataPieces.iterator();
            while (dataPiecesIterable.hasNext() && !hasDataPiece) {
                if (!dataPiecesIterable.next().getName().equals(dataName)) continue;
                hasDataPiece = true;
            }
            if (hasDataPiece) continue;
            throw new MaterialException("No data piece found for name: " + dataName);
        }
    }
}

