/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.parts;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.materialsystem.MaterialException;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.parts.PartBuilder;
import com.teamacronymcoders.base.materialsystem.parts.PartDataPiece;
import com.teamacronymcoders.base.materialsystem.parttype.BlockPartType;
import com.teamacronymcoders.base.materialsystem.parttype.FluidPartType;
import com.teamacronymcoders.base.materialsystem.parttype.ItemPartType;
import com.teamacronymcoders.base.materialsystem.parttype.OrePartType;
import com.teamacronymcoders.base.subblocksystem.SubBlockSystem;
import java.util.ArrayList;

public class ProvidedParts {
    private IBaseMod mod;
    private MaterialSystem materialSystem;

    public ProvidedParts(IBaseMod mod, MaterialSystem materialSystem, SubBlockSystem subBlockSystem) {
        this.mod = mod;
        this.materialSystem = materialSystem;
    }

    public void initPartsAndTypes() {
        ItemPartType item = new ItemPartType(this.mod);
        BlockPartType block = new BlockPartType(this.mod);
        OrePartType ore = new OrePartType(this.mod);
        FluidPartType fluid = new FluidPartType(this.mod);
        this.materialSystem.registerPartType(item);
        this.materialSystem.registerPartType(block);
        this.materialSystem.registerPartType(ore);
        this.materialSystem.registerPartType(fluid);
        this.registerPart(new PartBuilder(this.materialSystem).setName("Ingot").setPartType(item));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Beam").setPartType(item));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Gear").setPartType(item));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Bolt").setPartType(item));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Dust").setPartType(item));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Plate").setPartType(item));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Nugget").setPartType(item));
        ArrayList blockDataPieces = Lists.newArrayList();
        blockDataPieces.add(new PartDataPiece("hardness", false));
        blockDataPieces.add(new PartDataPiece("resistance", false));
        blockDataPieces.add(new PartDataPiece("harvestLevel", false));
        blockDataPieces.add(new PartDataPiece("harvestTool", false));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Block").setPartType(block).setData(blockDataPieces));
        ArrayList oreDataPieces = Lists.newArrayList();
        oreDataPieces.addAll(blockDataPieces);
        oreDataPieces.add(new PartDataPiece("variants", false));
        oreDataPieces.add(new PartDataPiece("dropType", false));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Ore").setPartType(ore).setData(oreDataPieces));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Poor Ore").setPartType(ore).setData(oreDataPieces));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Dense Ore").setPartType(ore).setData(oreDataPieces));
        ArrayList fluidDataPieces = Lists.newArrayList();
        fluidDataPieces.add(new PartDataPiece("temperature"));
        fluidDataPieces.add(new PartDataPiece("density"));
        fluidDataPieces.add(new PartDataPiece("viscosity"));
        fluidDataPieces.add(new PartDataPiece("vaporize"));
        this.registerPart(new PartBuilder(this.materialSystem).setName("Fluid").setPartType(fluid).setData(fluidDataPieces));
    }

    private void registerPart(PartBuilder partBuilder) {
        try {
            partBuilder.build();
        }
        catch (MaterialException e) {
            this.mod.getLogger().getLogger().error((Object)e);
        }
    }
}

