/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.modules.materials.items;

import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.api.materials.MaterialRegistry;
import com.teamacronymcoders.base.api.materials.MaterialType;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.items.IHasOreDict;
import com.teamacronymcoders.base.items.IHasRecipe;
import com.teamacronymcoders.base.items.ItemBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPart
extends ItemBase
implements IHasOreDict,
IHasItemColor,
IHasRecipe {
    private MaterialType.EnumPartType type;

    public ItemPart(MaterialType.EnumPartType type) {
        super(type.getName().toLowerCase());
        this.type = type;
        this.func_77627_a(true);
    }

    @Override
    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.getAllSubItems(subItems);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        MaterialType mat = MaterialRegistry.getFromID(stack.func_77952_i());
        if (mat != null && mat.isTypeSet(this.type)) {
            return String.format("item.base.%s.%s", this.type.name().toLowerCase(), mat.getName().toLowerCase());
        }
        return "item.base.null_part";
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        MaterialType mat = MaterialRegistry.getFromID(stack.func_77952_i());
        if (mat != null && mat.isTypeSet(this.type)) {
            return String.format("%s %s", mat.getLocalizedName(), this.type.getLocalizedName());
        }
        return TextFormatting.RED + Base.languageHelper.error("null_part");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        MaterialType mat = MaterialRegistry.getFromID(stack.func_77952_i());
        if (mat != null && mat.isTypeSet(this.type)) {
            return mat.isHasEffect();
        }
        return super.func_77636_d(stack);
    }

    @Override
    public List<String> getModelNames(List<String> modelNames) {
        modelNames.add(this.type.getName().toLowerCase());
        return modelNames;
    }

    @Override
    @Nonnull
    public Map<ItemStack, String> getOreDictNames(@Nonnull Map<ItemStack, String> names) {
        for (Map.Entry ent : MaterialRegistry.getMaterials().entrySet()) {
            MaterialType mat = (MaterialType)ent.getValue();
            if (!mat.isTypeSet(this.type)) continue;
            ItemStack itemStack = new ItemStack((Item)this, 1, ((Integer)ent.getKey()).intValue());
            String oreDictName = this.type.getOreDictName(mat);
            names.put(itemStack, oreDictName);
        }
        return names;
    }

    @Override
    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        MaterialType material = MaterialRegistry.getFromID(stack.func_77952_i());
        if (material != null && tintIndex == 0) {
            return material.getColour().getRGB();
        }
        return 0xFFFFFF;
    }

    @Override
    public List<ItemStack> getAllSubItems(List<ItemStack> itemStacks) {
        MaterialRegistry.getMaterials().entrySet().stream().filter(entry -> ((MaterialType)entry.getValue()).isTypeSet(this.type)).forEach(entry -> itemStacks.add(new ItemStack((Item)this, 1, ((Integer)entry.getKey()).intValue())));
        return itemStacks;
    }

    @Override
    public List<IRecipe> getRecipes(List<IRecipe> recipes) {
        this.getAllSubItems(new ArrayList<ItemStack>()).forEach(itemStack -> this.type.getRecipes(recipes, MaterialRegistry.getFromID(itemStack.func_77952_i()), (ItemStack)itemStack));
        return recipes;
    }
}

