/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.modules.minetweaker;

import com.teamacronymcoders.base.api.materials.MaterialRegistry;
import com.teamacronymcoders.base.api.materials.MaterialType;
import com.teamacronymcoders.base.exceptions.TooLateException;
import com.teamacronymcoders.base.modules.minetweaker.BaseMaterialType;
import com.teamacronymcoders.base.modules.minetweaker.IMaterialType;
import com.teamacronymcoders.base.modules.minetweaker.MinetweakerModule;
import java.awt.Color;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.base.Materials")
public class Materials {
    @ZenMethod
    public static IMaterialType getOrRegister(String name, @Optional int ID, @Optional int colour, @Optional boolean hasEffect) throws TooLateException {
        if (MinetweakerModule.tooLate) {
            throw new TooLateException("You have to put scripts using BASE Functionality in ./config/ACRONYM/BASE/scripts");
        }
        if (MaterialRegistry.isRegistered(name)) {
            return new BaseMaterialType(MaterialRegistry.getFromName(name));
        }
        if (ID == 0) {
            MineTweakerAPI.logError((String)"ID is either missing or is 0!");
            return null;
        }
        Color col = new Color(colour);
        MineTweakerAPI.apply((IUndoableAction)new Add(name, ID, col, hasEffect));
        return new BaseMaterialType(MaterialRegistry.getFromName(name));
    }

    private static class Add
    implements IUndoableAction {
        private String name;
        private int ID;
        private Color colour;
        private boolean hasEffect;

        public Add(String name, int ID, Color colour, boolean hasEffect) {
            this.name = name;
            this.ID = ID;
            this.colour = colour;
            this.hasEffect = hasEffect;
        }

        public void apply() {
            if (!MaterialRegistry.isRegistered(this.name)) {
                MaterialRegistry.registerMaterial(this.ID, new MaterialType(this.name, this.colour, this.hasEffect));
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
        }

        public String describe() {
            return String.format("[%s] Registering BaseMaterial, %s", "base", this.name);
        }

        public String describeUndo() {
            return String.format("[%s] Unable to remove BaseMaterial, %s, while the game is running!", "base", this.name);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    public static class Change
    implements IUndoableAction {
        private MaterialType mat;
        private MaterialType.EnumPartType type;

        public Change(MaterialType mat, MaterialType.EnumPartType type) {
            this.mat = mat;
            this.type = type;
        }

        public void apply() {
            this.mat.getTypes().add(this.type);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
        }

        public String describe() {
            return String.format("[%s] Registering Part Type, %s, for BaseMaterial, %s", "base", this.type.getName(), this.mat.getName());
        }

        public String describeUndo() {
            return String.format("[%s] Removing Part Type, %s, for BaseMaterial, %s", "base", this.type.getName(), this.mat.getName());
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

