/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.modules.texturegenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class FileHelper {
    public List<String> scanFile(String modid, String key, String texture, File base) {
        ArrayList<String> content = new ArrayList<String>();
        try {
            Scanner scan = new Scanner(base);
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                content.add(line.replaceAll("%modid%", modid).replaceAll("%key%", key).replaceAll("%texture%", texture));
            }
            scan.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return content;
    }

    public void writeFile(File base, List<String> content) {
        try {
            FileWriter write = new FileWriter(base);
            for (String s : content) {
                write.write(s + "\n");
            }
            write.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFromJar(Class baseClass, String fileName, File to) {
        URL baseUrl = baseClass.getResource("/assets/" + fileName);
        try {
            FileUtils.copyURLToFile((URL)baseUrl, (File)to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolderContents(File directory, File zipfile) {
        try {
            URI base = directory.toURI();
            LinkedList<File> queue = new LinkedList<File>();
            queue.push(directory);
            FileOutputStream out = new FileOutputStream(zipfile);
            try (OutputStream res = out;){
                ZipOutputStream zout = new ZipOutputStream(out);
                res = zout;
                while (!queue.isEmpty()) {
                    directory = (File)queue.pop();
                    for (File child : directory.listFiles()) {
                        String name = base.relativize(child.toURI()).getPath();
                        if (child.isDirectory()) {
                            queue.push(child);
                            name = name.endsWith("/") ? name : name + "/";
                            zout.putNextEntry(new ZipEntry(name));
                            continue;
                        }
                        zout.putNextEntry(new ZipEntry(name));
                        FileHelper.copy(child, (OutputStream)zout);
                        zout.closeEntry();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copy(InputStream in, OutputStream out) {
        try {
            int readCount;
            byte[] buffer = new byte[1024];
            while ((readCount = in.read(buffer)) >= 0) {
                out.write(buffer, 0, readCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copy(File file, OutputStream out) {
        try (FileInputStream in = new FileInputStream(file);){
            FileHelper.copy(in, out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

