/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.proxies;

import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.blocks.IHasBlockStateMapper;
import com.teamacronymcoders.base.client.BlockStateMappers;
import com.teamacronymcoders.base.client.ClientHelper;
import com.teamacronymcoders.base.client.Colors;
import com.teamacronymcoders.base.client.Models;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.client.models.wrapped.WrappedBlockEntry;
import com.teamacronymcoders.base.client.models.wrapped.WrappedModelLoader;
import com.teamacronymcoders.base.items.IHasItemColor;
import com.teamacronymcoders.base.modulesystem.IModule;
import com.teamacronymcoders.base.modulesystem.proxies.IModuleProxy;
import com.teamacronymcoders.base.proxies.LibCommonProxy;
import com.teamacronymcoders.base.registry.pieces.RegistrySide;
import com.teamacronymcoders.base.util.Platform;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class LibClientProxy
extends LibCommonProxy {
    @Override
    public void addOBJDomain() {
        OBJLoader.INSTANCE.addDomain(this.getMod().getID());
    }

    @Override
    public void setItemModel(Item item, int metadata, ResourceLocation resourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, ""));
    }

    @Override
    public void setAllItemModels(Item item, IHasModel model) {
        Models.registerModels(model);
    }

    @Override
    public void registerFluidModel(Block fluidBlock, ResourceLocation resourceLocation) {
        Item fluidItem = Item.func_150898_a((Block)fluidBlock);
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, "normal");
        if (fluidItem != null) {
            ModelBakery.registerItemVariants((Item)fluidItem, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)fluidItem, stack -> modelResourceLocation);
            ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)new StateMapperBase(){

                @Nonnull
                protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                    return modelResourceLocation;
                }
            });
        }
    }

    @Override
    public void registerItemColor(Item item, IHasItemColor itemColor) {
        Colors.registerItemColor(item, itemColor);
    }

    @Override
    public void registerItemColor(Block block, IHasItemColor itemColor) {
        Colors.registerItemColor(block, itemColor);
    }

    @Override
    public void registerBlockColor(IHasBlockColor blockColor) {
        Colors.registerBlockColor(blockColor);
    }

    @Override
    public void registerBlockStateMapper(Block block, IHasBlockStateMapper stateMapper) {
        BlockStateMappers.registerStateMapper(stateMapper);
    }

    @Override
    public RegistrySide getRegistrySide() {
        return RegistrySide.CLIENT;
    }

    @Override
    public IModuleProxy getModuleProxy(IModule module) {
        return this.getModuleProxy(module.getClientProxyPath());
    }

    @Override
    public void registerModelVariant(Item item, ResourceLocation resourceLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
    }

    @Override
    public void registerWrappedModel(ResourceLocation resourceLocation, WrappedBlockEntry wrappedBlockEntry) {
        WrappedModelLoader.addModel(resourceLocation, wrappedBlockEntry);
    }

    @Override
    public String getFileContents(ResourceLocation location) {
        location = new ResourceLocation(location.func_110624_b(), "templates/" + location.func_110623_a() + ".json");
        IResource resource = ClientHelper.getResource(location);
        String fileContents = "";
        if (resource != null) {
            InputStream inputStream = resource.func_110527_b();
            try {
                fileContents = IOUtils.toString((InputStream)inputStream);
            }
            catch (IOException e) {
                Platform.attemptLogExceptionToCurrentMod(e);
            }
        }
        return fileContents;
    }
}

