/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem.blocks;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.blocks.BlockBaseNoModel;
import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.blocks.IHasBlockStateMapper;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.items.IHasOreDict;
import com.teamacronymcoders.base.items.IHasRecipe;
import com.teamacronymcoders.base.subblocksystem.SubBlockSystem;
import com.teamacronymcoders.base.subblocksystem.blocks.ISubBlock;
import com.teamacronymcoders.base.subblocksystem.items.ItemBlockSubBlockHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSubBlockHolder
extends BlockBaseNoModel
implements IHasBlockStateMapper,
IHasBlockColor,
IHasOreDict,
IHasRecipe,
IHasGeneratedModel {
    public static final PropertyInteger SUB_BLOCK_NUMBER = PropertyInteger.func_177719_a((String)"sub_block_number", (int)0, (int)15);
    private Map<Integer, ISubBlock> subBlocks;

    public BlockSubBlockHolder(int number, Map<Integer, ISubBlock> subBlocks) {
        super(Material.field_151573_f, "sub_block_holder_" + number);
        this.setItemBlock(new ItemBlockSubBlockHolder(this));
        this.subBlocks = subBlocks;
        for (int x = 0; x < 16; ++x) {
            this.getSubBlocks().putIfAbsent(x, SubBlockSystem.MISSING_SUB_BLOCK);
            this.getSubBlock(x).setItemStack(new ItemStack((Item)this.getItemBlock(), 1, x));
        }
    }

    @Override
    public List<ItemStack> getAllSubItems(List<ItemStack> itemStacks) {
        for (int x = 0; x < 16; ++x) {
            if (this.getSubBlocks().get(x) == SubBlockSystem.MISSING_SUB_BLOCK) continue;
            itemStacks.add(new ItemStack((Item)this.getItemBlock(), 1, x));
        }
        return itemStacks;
    }

    @Override
    public void func_149666_a(@Nonnull Item block, @Nullable CreativeTabs creativeTab, @Nonnull List<ItemStack> list) {
        for (Map.Entry<Integer, ISubBlock> subBlock : this.getSubBlocks().entrySet()) {
            if (subBlock.getValue().getCreativeTab() != creativeTab) continue;
            list.add(new ItemStack(block, 1, subBlock.getKey().intValue()));
        }
    }

    public float func_176195_g(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        return this.getSubBlock((Integer)blockState.func_177229_b((IProperty)SUB_BLOCK_NUMBER)).getHardness();
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity exploder, @Nonnull Explosion explosion) {
        return this.getSubBlock((Integer)world.func_180495_p(pos).func_177229_b((IProperty)SUB_BLOCK_NUMBER)).getResistance();
    }

    @Nonnull
    public String getHarvestTool(@Nonnull IBlockState state) {
        return this.getSubBlock((Integer)state.func_177229_b((IProperty)SUB_BLOCK_NUMBER)).getHarvestTool();
    }

    public int getHarvestLevel(@Nonnull IBlockState state) {
        return this.getSubBlock((Integer)state.func_177229_b((IProperty)SUB_BLOCK_NUMBER)).getHarvestLevel();
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ArrayList itemStacks = Lists.newArrayList();
        this.getSubBlock(state).getDrops(fortune, itemStacks);
        return itemStacks;
    }

    @Override
    public ResourceLocation getResourceLocation(IBlockState blockState) {
        return this.getSubBlock(blockState).getTextureLocation();
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ISubBlock getSubBlock(IBlockState blockState) {
        return this.getSubBlock((Integer)blockState.func_177229_b((IProperty)SUB_BLOCK_NUMBER));
    }

    public ISubBlock getSubBlock(int meta) {
        return this.getSubBlocks().get(meta);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SUB_BLOCK_NUMBER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SUB_BLOCK_NUMBER);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SUB_BLOCK_NUMBER});
    }

    @Override
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        return this.getSubBlock((Integer)state.func_177229_b((IProperty)SUB_BLOCK_NUMBER)).getColor();
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SUB_BLOCK_NUMBER);
    }

    public Map<Integer, ISubBlock> getSubBlocks() {
        return this.subBlocks;
    }

    @Override
    @Nonnull
    public Map<ItemStack, String> getOreDictNames(@Nonnull Map<ItemStack, String> names) {
        this.getSubBlocks().forEach((key, value) -> {
            String oreDict = value.getOreDict();
            if (oreDict != null && !oreDict.isEmpty()) {
                names.put(new ItemStack((Item)this.getItemBlock(), 1, key.intValue()), oreDict);
            }
        });
        return names;
    }

    @Override
    public List<IRecipe> getRecipes(List<IRecipe> recipes) {
        this.getSubBlocks().values().forEach(subBlock -> subBlock.setRecipes(recipes));
        return recipes;
    }

    @Override
    public List<IGeneratedModel> getGeneratedModels() {
        return this.getSubBlocks().values().stream().map(ISubBlock::getGeneratedModel).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

