/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem.blocks;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.subblocksystem.blocks.ISubBlock;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public abstract class SubBlockBase
implements ISubBlock {
    private String name;
    private ResourceLocation textureLocation;
    protected ItemStack itemStack;

    public SubBlockBase(String name) {
        this.name = name;
        this.textureLocation = new ResourceLocation("base", this.getModelPrefix() + name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnLocalizedName() {
        return "base.subblock." + this.name;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    @Override
    public int getColor() {
        return -1;
    }

    @Override
    public void getDrops(int fortune, List<ItemStack> itemStacks) {
        itemStacks.add(this.itemStack);
    }

    @Override
    public void setRecipes(List<IRecipe> recipes) {
    }

    @Override
    public String getOreDict() {
        return null;
    }

    @Override
    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public IGeneratedModel getGeneratedModel() {
        TemplateFile templateFile = TemplateManager.getTemplateFile("sub_block_state");
        HashMap replacements = Maps.newHashMap();
        replacements.put("texture", new ResourceLocation(this.getTextureLocation().func_110624_b(), "blocks/" + this.getTextureLocation().func_110623_a()).toString());
        templateFile.replaceContents(replacements);
        return new GeneratedModel(this.getModelPrefix() + this.getUnLocalizedName(), ModelType.BLOCKSTATE, templateFile.getFileContents());
    }

    protected String getModelPrefix() {
        return "";
    }
}

