/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks.slabs;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import tt.betterslabsmod.items.ItemSlab;
import tt.betterslabsmod.items.ItemSlabDirectional;
import tt.betterslabsmod.main.CommonProxy;
import tt.betterslabsmod.utils.Constants;
import tt.betterslabsmod.utils.Pair;
import tt.betterslabsmod.utils.SlabState;

public class Slab
extends Block {
    private String name;
    private IBlockState full_block;

    public Slab(String name, Block full_block) {
        this(name, full_block.func_176223_P());
    }

    public Slab(String name, IBlockState full_block) {
        super(full_block.func_185904_a());
        this.name = StringUtils.uncapitalize((String)name);
        this.full_block = full_block;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabState.DOWN)));
        this.register();
    }

    private void register() {
        this.setRegistryName("betterslabsmod", this.name);
        if (this.name.contains("axis")) {
            if (this.name.contains("y_axis")) {
                this.func_149663_c("betterslabsmod." + StringUtils.substringBefore((String)this.name, (String)"facing") + "slab");
                CommonProxy.BLOCK_REGISTRY.put(this.getName(), Pair.of((Object)this, new ItemSlabDirectional(this).setRegistryName("betterslabsmod", StringUtils.substringBefore((String)this.name, (String)"facing") + "slab")));
            } else {
                CommonProxy.BLOCK_REGISTRY.put(this.getName(), Pair.of((Object)this, (Object)Constants.PLACEHOLDER_ITEM_SLAB));
            }
        } else {
            this.func_149663_c("betterslabsmod." + this.name);
            CommonProxy.BLOCK_REGISTRY.put(this.getName(), Pair.of((Object)this, new ItemSlab(this).setRegistryName(this.getRegistryName())));
        }
    }

    public Slab disableStatistics() {
        super.func_149649_H();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public IBlockState getFullBlock() {
        return this.full_block;
    }

    public String toString() {
        return this.name;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Constants.SLAB_STATE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabState.getSlabStateByID(meta)));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((SlabState)((Object)blockState.func_177229_b(Constants.SLAB_STATE))).getID();
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos position) {
        return this.full_block.func_185887_b(world, position) / 2.0f;
    }

    public float getExplosionResistance(World world, BlockPos position, @Nullable Entity exploder, Explosion explosion) {
        return this.full_block.func_177230_c().getExplosionResistance(world, position, exploder, explosion) / 2.0f;
    }

    public SoundType getSoundType(IBlockState blockState, World world, BlockPos position, @Nullable Entity entity) {
        return this.full_block.func_177230_c().func_185467_w();
    }

    public MapColor func_180659_g(IBlockState blockState, IBlockAccess world, BlockPos position) {
        return this.full_block.func_185909_g(world, position);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(Constants.SLAB_STATE) == SlabState.UP;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos position, EnumFacing side) {
        return SlabState.isSideSolid((SlabState)((Object)state.func_177229_b(Constants.SLAB_STATE)), side);
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess world, BlockPos blockPosition) {
        int slabStateID = ((SlabState)((Object)blockState.func_177229_b(Constants.SLAB_STATE))).getID();
        return Constants.bounding_boxes[slabStateID < 9 ? slabStateID : 9];
    }

    public void func_185477_a(IBlockState blockState, World world, BlockPos blockPosition, AxisAlignedBB axisAlignedBB, List<AxisAlignedBB> list, @Nullable Entity player, boolean bool) {
        int slabStateID = ((SlabState)((Object)blockState.func_177229_b(Constants.SLAB_STATE))).getID();
        if (slabStateID < 9) {
            Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)Constants.bounding_boxes[slabStateID]);
        } else if (slabStateID >= 9 && slabStateID <= 12) {
            Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            if (slabStateID == 9) {
                Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5));
            } else if (slabStateID == 10) {
                Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0));
            } else if (slabStateID == 11) {
                Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0));
            } else if (slabStateID == 12) {
                Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0));
            }
        } else if (slabStateID == 13) {
            Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5));
            Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 1.0, 1.0));
        } else if (slabStateID == 14) {
            Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 1.0, 1.0));
            Slab.func_185492_a((BlockPos)blockPosition, (AxisAlignedBB)axisAlignedBB, list, (AxisAlignedBB)new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.5));
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public ItemStack getPickBlock(IBlockState blockState, RayTraceResult rayTrace, World world, BlockPos blockPosistion, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }
}

