/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks.slabs;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tt.betterslabsmod.blocks.slabs.Slab;

public class SlabColored
extends Slab {
    private boolean isGlass;

    public SlabColored(ColoredVariant variant, Color color) {
        super(variant.getSlabName(color), variant.getFullBlock(color));
        this.isGlass = variant == ColoredVariant.STAINED_GLASS;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isGlass ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos position, EnumFacing side) {
        if (this.isGlass) {
            IBlockState iState = world.func_180495_p(position.func_177972_a(side));
            Block block = iState.func_177230_c();
            if (blockState != iState) {
                return true;
            }
            return block != this;
        }
        return super.func_176225_a(blockState, world, position, side);
    }

    public int func_149745_a(Random random) {
        return this.isGlass ? 0 : 1;
    }

    protected boolean func_149700_E() {
        return this.isGlass;
    }

    public static enum Color {
        WHITE("white", 0, MapColor.field_151666_j),
        ORANGE("orange", 1, MapColor.field_151676_q),
        MAGENTA("magenta", 2, MapColor.field_151675_r),
        LIGHT_BLUE("light_blue", 3, MapColor.field_151674_s),
        YELLOW("yellow", 4, MapColor.field_151673_t),
        LIME("lime", 5, MapColor.field_151672_u),
        PINK("pink", 6, MapColor.field_151671_v),
        GRAY("gray", 7, MapColor.field_151670_w),
        LIGHT_GRAY("light_gray", 8, MapColor.field_151680_x),
        CYAN("cyan", 9, MapColor.field_151679_y),
        PURPLE("purple", 10, MapColor.field_151678_z),
        BLUE("blue", 11, MapColor.field_151649_A),
        BROWN("brown", 12, MapColor.field_151650_B),
        GREEN("green", 13, MapColor.field_151651_C),
        RED("red", 14, MapColor.field_151645_D),
        BLACK("black", 15, MapColor.field_151646_E);

        private String name;
        private int blockMeta;
        private int itemMeta;
        private MapColor mapColor;

        private Color(String name_, int meta, MapColor mapColor_) {
            this.name = name_;
            this.blockMeta = meta;
            this.itemMeta = 16 - meta;
            this.mapColor = mapColor_;
        }

        public String getName() {
            return this.name;
        }

        public int getBlockMeta() {
            return this.blockMeta;
        }

        public int getItemMeta() {
            return this.itemMeta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }
    }

    public static enum ColoredVariant {
        WOOL("wool", Blocks.field_150325_L),
        STAINED_GLASS("stained_glass", (Block)Blocks.field_150399_cn),
        HARDENED_CLAY("hardened_clay", Blocks.field_150406_ce),
        CONCRETE("concrete", Blocks.field_192443_dR),
        CONCRETE_POWDER("concrete_powder", Blocks.field_192444_dS);

        private String variant_name;
        private IBlockState fullBlock;

        private ColoredVariant(String variant_name, Block full_block) {
            this.variant_name = variant_name + "_slab";
            this.fullBlock = full_block.func_176223_P();
        }

        public String getSlabName(Color color) {
            return color.getName() + "_" + this.variant_name;
        }

        public IBlockState getFullBlock(Color color) {
            return this.fullBlock.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.values()[color.getBlockMeta()]);
        }
    }
}

