/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks.slabs;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tt.betterslabsmod.blocks.slabs.SlabColored;
import tt.betterslabsmod.utils.IGravityProvider;

public class SlabConcretePowder
extends SlabColored
implements IGravityProvider {
    public SlabConcretePowder(SlabColored.Color color) {
        super(SlabColored.ColoredVariant.CONCRETE_POWDER, color);
        this.func_149675_a(true);
    }

    public int func_149738_a(World world) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos position, Random random) {
        BlockPos blockpos;
        if (random.nextInt(16) == 0 && this.canFallThrough(world.func_180495_p(blockpos = position.func_177977_b()))) {
            double d0 = (float)position.func_177958_n() + random.nextFloat();
            double d1 = (double)position.func_177956_o() - 0.05;
            double d2 = (float)position.func_177952_p() + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public void func_176213_c(World world, BlockPos position, IBlockState state) {
        world.func_175684_a(position, (Block)this, this.func_149738_a(world));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos position, Block block, BlockPos fromPosition) {
        world.func_175684_a(position, (Block)this, this.func_149738_a(world));
    }

    public void func_180650_b(World world, BlockPos position, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            this.checkFallable(world, position);
        }
    }

    @Override
    public void checkFallable(World world, BlockPos position) {
        if ((world.func_175623_d(position.func_177977_b()) || this.canFallThrough(world.func_180495_p(position.func_177977_b()))) && position.func_177956_o() >= 0) {
            int i = 32;
            if (world.func_175707_a(position.func_177982_a(-32, -32, -32), position.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityFallingBlock(world, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o(), (double)position.func_177952_p() + 0.5, world.func_180495_p(position)));
                }
            } else {
                IBlockState state = world.func_180495_p(position);
                world.func_175698_g(position);
                BlockPos blockpos = position.func_177977_b();
                while ((world.func_175623_d(blockpos) || this.canFallThrough(world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    @Override
    public boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }
}

