/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks.slabs;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tt.betterslabsmod.blocks.slabs.Slab;
import tt.betterslabsmod.init.BlockFactory;
import tt.betterslabsmod.main.CommonProxy;
import tt.betterslabsmod.options.Options;
import tt.betterslabsmod.utils.Constants;
import tt.betterslabsmod.utils.SlabState;

public class SlabGrass
extends Slab {
    public SlabGrass() {
        super("grass_slab", Blocks.field_150349_c.func_176223_P());
        this.func_149675_a(Options.ALLOW_GRASS_SLAB_SPREADING && !Options.ALLOW_GRASS_SLAB_LIFE_UNDER_FULL_BLOCK);
        this.func_180632_j(this.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabState.DOWN)).func_177226_a((IProperty)BlockGrass.field_176498_a, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Constants.SLAB_STATE, BlockGrass.field_176498_a});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        return state.func_177226_a(Constants.SLAB_STATE, state.func_177229_b(Constants.SLAB_STATE)).func_177226_a((IProperty)BlockGrass.field_176498_a, (Comparable)Boolean.valueOf(this.getSnowyValue(world, position)));
    }

    private boolean getSnowyValue(IBlockAccess world, BlockPos blockPosition) {
        boolean isSnowy = false;
        if (Options.ALLOW_ADVANCED_SNOWY_GRASS_SLAB_TEXTURES) {
            Iterable surroundingPositions = BlockPos.func_177980_a((BlockPos)blockPosition.func_177968_d().func_177976_e(), (BlockPos)blockPosition.func_177978_c().func_177974_f());
            for (BlockPos position : surroundingPositions) {
                IBlockState state = world.func_180495_p(position);
                if (!this.isSnowyState(state)) continue;
                isSnowy = true;
                break;
            }
        } else {
            isSnowy = this.isSnowyState(world.func_180495_p(blockPosition.func_177984_a()));
        }
        return isSnowy;
    }

    private boolean isSnowyState(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150433_aE || state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c() == Blocks.field_150349_c && (Boolean)state.func_177229_b((IProperty)BlockGrass.field_176498_a) == true;
    }

    public void func_180650_b(World world, BlockPos position, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            if (!Options.isSlabAllowed("dirt_slab") || !Options.ALLOW_GRASS_SLAB_LIFE_UNDER_FULL_BLOCK) {
                // empty if block
            }
        }
        if (world.func_175671_l(position.func_177984_a()) < 4 && world.func_180495_p(position.func_177984_a()).getLightOpacity((IBlockAccess)world, position.func_177984_a()) > 2) {
            world.func_175656_a(position, BlockFactory.DIRT_SLAB.func_176223_P().func_177226_a(Constants.SLAB_STATE, state.func_177229_b(Constants.SLAB_STATE)));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)CommonProxy.BLOCK_REGISTRY.getSlabWithReplacement("dirt_slab", "grass_slab", "Drop for Grass Slab"));
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_180651_a(IBlockState blockState) {
        return 0;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

