/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.blocks.slabs;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import tt.betterslabsmod.blocks.slabs.Slab;

public class SlabMushroom
extends Slab {
    private Item itemDropped;

    public SlabMushroom(MushroomVariant variant) {
        super(variant.getName(), variant.getFullBlock());
        this.itemDropped = variant.getItemDropped();
    }

    public Item func_180660_a(IBlockState blockState, Random random, int fortune) {
        return this.itemDropped;
    }

    public int func_149745_a(Random random) {
        return Math.floorDiv(Math.max(0, random.nextInt(10) - 7), 2);
    }

    public static enum MushroomVariant {
        RED_MUSHROOM_STEM("red_mushroom_stem", false, BlockHugeMushroom.EnumType.STEM, (Block)Blocks.field_150337_Q),
        BROWN_MUSHROOM_STEM("brown_mushroom_stem", true, BlockHugeMushroom.EnumType.STEM, (Block)Blocks.field_150338_P),
        RED_MUSHROOM("red_mushroom", false, BlockHugeMushroom.EnumType.ALL_OUTSIDE, (Block)Blocks.field_150337_Q),
        BROWN_MUSHROOM("brown_mushroom", true, BlockHugeMushroom.EnumType.ALL_OUTSIDE, (Block)Blocks.field_150338_P);

        private String name;
        private IBlockState fullBlock;
        private Item itemDropped;

        private MushroomVariant(String name_, boolean isBrown, BlockHugeMushroom.EnumType type, Block itemDropped_) {
            this.name = name_ + "_slab";
            this.fullBlock = (isBrown ? Blocks.field_150420_aW : Blocks.field_150419_aX).func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)type);
            this.itemDropped = Item.func_150898_a((Block)itemDropped_);
        }

        public String getName() {
            return this.name;
        }

        public IBlockState getFullBlock() {
            return this.fullBlock;
        }

        public Item getItemDropped() {
            return this.itemDropped;
        }
    }
}

