/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import tt.betterslabsmod.main.BetterSlabsMod;

public final class ConfigurationFile {
    private String path;

    private ConfigurationFile(String path_to_configuration_file) {
        this.path = path_to_configuration_file;
    }

    public static ConfigurationFile in(String path_to_configuration_file) {
        return new ConfigurationFile(path_to_configuration_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File configurationFile = new File(this.path + "/Better Slabs Mod.config");
        if (!configurationFile.exists()) {
            BetterSlabsMod.log("Configuration file not found! Generating a new one!");
            InputStream inputStream = null;
            try {
                BetterSlabsMod.log("Downloading a new configuration file!");
                inputStream = new URL("https://raw.githubusercontent.com/TheTrollguyGithub/MinecraftMods/master/Better%20Slabs%20Mod%20Configuration%20File").openStream();
            }
            catch (MalformedURLException exception) {
                BetterSlabsMod.warn("Unable to download a new conifguration file!");
                exception.printStackTrace();
            }
            catch (IOException exception) {
                BetterSlabsMod.warn("Unable to download a new conifguration file!");
                exception.printStackTrace();
            }
            finally {
                try {
                    FileUtils.writeLines((File)configurationFile, (String)"UTF-8", (Collection)IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset()));
                    inputStream.close();
                    BetterSlabsMod.log("Successfully downloaded and created a new configuration file!");
                }
                catch (IOException eexception) {
                    BetterSlabsMod.warn("Unable to create a new conifguration file!");
                    eexception.printStackTrace();
                }
            }
        }
        if (configurationFile.exists()) {
            List lines = null;
            try {
                BetterSlabsMod.log("Reading the configuration file!");
                lines = FileUtils.readLines((File)configurationFile, (String)"UTF-8");
            }
            catch (IOException exception) {
                BetterSlabsMod.warn("Could not read the configuration file! Things are not going to be good! :(");
                exception.printStackTrace();
            }
            if (lines != null) {
                for (String line : lines) {
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] data = line.split("=");
                    data[0] = data[0].trim().replace(" ", "");
                    if (data[0].endsWith("_slab")) {
                        BetterSlabsMod.permission_keys.insert(data[0], data[1]);
                        continue;
                    }
                    if (!data[0].startsWith("allow")) continue;
                    BetterSlabsMod.mod_rules.insert(data[0], data[1]);
                }
            }
            BetterSlabsMod.log("Configuration file successfully read!");
        } else {
            BetterSlabsMod.warn("Somehow the configuration file does not exist after its creation. What in the...");
        }
    }
}

