/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.items;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import tt.betterslabsmod.blocks.slabs.Slab;
import tt.betterslabsmod.capability.axismode.AxisMode;
import tt.betterslabsmod.capability.axismode.CapabilityAxisMode;
import tt.betterslabsmod.capability.axismode.IAxisMode;
import tt.betterslabsmod.capability.placementmode.CapabilityPlacementMode;
import tt.betterslabsmod.capability.placementmode.IPlacementMode;
import tt.betterslabsmod.capability.placementmode.PlacementMode;
import tt.betterslabsmod.client.ClientProxy;
import tt.betterslabsmod.main.BetterSlabsMod;
import tt.betterslabsmod.options.Options;
import tt.betterslabsmod.utils.Constants;
import tt.betterslabsmod.utils.Pair;
import tt.betterslabsmod.utils.SlabState;
import tt.betterslabsmod.utils.SlabStateHelper;

public class ItemSlab
extends ItemBlock {
    protected Slab slab;

    public ItemSlab(@Nullable Slab slab) {
        super((Block)slab);
        if (slab == null) {
            BetterSlabsMod.log("Created a placeholder for null-ItemSlab object.");
        }
        this.slab = slab;
        this.func_77656_e(0);
    }

    public void setSlabTo(Slab new_slab) {
        this.slab = new_slab;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (selected && world.field_72995_K && ClientProxy.isDirectionalBlockInHands) {
            Options.notifyAboutDirectionalBlockInHands(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos position, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_184614_ca().func_190926_b() && player.field_71075_bZ.field_75099_e) {
            Slab slab_input = this.slab;
            PlacementMode mode = ((IPlacementMode)player.getCapability(CapabilityPlacementMode.CAPABILITY, null)).getCurrentPlacementMode();
            String currentAxisMode = ((IAxisMode)player.getCapability(CapabilityAxisMode.CAPABILITY, null)).getCurrentAxisMode().name;
            if (slab_input.getName().contains("facing") && !AxisMode.getAxisForBlock((String)slab_input.getName()).name.equals(currentAxisMode)) {
                slab_input = (Slab)Block.func_149684_b((String)("betterslabsmod:" + StringUtils.substringBefore((String)this.slab.getName(), (String)"facing") + "facing_" + currentAxisMode + "_slab"));
            }
            Pair<BlockPos, IBlockState> pair = this.getDetails(slab_input, slab_input.getFullBlock(), world, position, player, hitX, hitY, hitZ, side, mode);
            boolean canPlace = true;
            if (pair.getFirstElement().equals((Object)position.func_177972_a(side))) {
                canPlace = world.func_180495_p(pair.getFirstElement()).func_177230_c() == Blocks.field_150350_a;
            }
            BetterSlabsMod.log(String.valueOf(canPlace));
            if (!world.field_72995_K && canPlace) {
                world.func_175656_a(pair.getFirstElement(), pair.getSecondElement());
                this.playSound(world, position, player);
                player.func_184614_ca().func_190918_g(1);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, position, player.func_184614_ca());
                }
            }
            return canPlace ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    public Pair<BlockPos, IBlockState> getDetails(Slab slab, IBlockState full_block, World world, BlockPos position, EntityPlayer player, float hitX, float hitY, float hitZ, EnumFacing side, PlacementMode mode) {
        IBlockState blockLookedAt = world.func_180495_p(position);
        boolean isShiftDown = Keyboard.isKeyDown((int)42);
        if (blockLookedAt.func_177230_c() == slab && mode != PlacementMode.RANDOM && this.canMakeFullBlock((SlabState)((Object)blockLookedAt.func_177229_b(Constants.SLAB_STATE)), side)) {
            return Pair.of(position, full_block);
        }
        blockLookedAt = world.func_180495_p(position = position.func_177972_a(side));
        if (blockLookedAt.func_177230_c() == slab && mode != PlacementMode.RANDOM) {
            return Pair.of(position, full_block);
        }
        if (mode == PlacementMode.NORMAL) {
            boolean upperHalf = side == EnumFacing.DOWN || (double)hitY >= 0.5 && (double)hitY < 1.0;
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)(upperHalf ? SlabState.UP : SlabState.DOWN))));
        }
        if (mode == PlacementMode.VERTICAL) {
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabStateHelper.getStateForVerticalMode(player.func_174811_aO()))));
        }
        if (mode == PlacementMode.FACED) {
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabState.getStateFromSide(side))));
        }
        if (mode == PlacementMode.SLOPE) {
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabStateHelper.getStateForSlopeMode(player.func_174811_aO()))));
        }
        if (mode == PlacementMode.AXIS) {
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabStateHelper.getStateForAxisMode(side))));
        }
        if (mode == PlacementMode.ROTATIONAL) {
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
            SlabState[] states = new SlabState[]{SlabState.Z_AXIS, SlabState.DIAGONAL_RIGHT, SlabState.X_AXIS, SlabState.DIAGONAL_LEFT};
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)states[facing % 4])));
        }
        if (mode == PlacementMode.RANDOM) {
            return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabState.values()[new Random().nextInt(SlabState.values().length)])));
        }
        return Pair.of(position, slab.func_176223_P().func_177226_a(Constants.SLAB_STATE, (Comparable)((Object)SlabState.DOWN)));
    }

    private boolean canMakeFullBlock(SlabState state, EnumFacing side) {
        boolean value = false;
        switch (state) {
            case NORTH: {
                value = side == EnumFacing.SOUTH;
                break;
            }
            case EAST: {
                value = side == EnumFacing.WEST;
                break;
            }
            case SOUTH: {
                value = side == EnumFacing.NORTH;
                break;
            }
            case WEST: {
                value = side == EnumFacing.EAST;
                break;
            }
            case DOWN: {
                value = side == EnumFacing.UP;
                break;
            }
            case UP: {
                value = side == EnumFacing.DOWN;
                break;
            }
            case X_AXIS: {
                value = side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
                break;
            }
            case Y_AXIS: {
                value = side == EnumFacing.UP || side == EnumFacing.DOWN;
                break;
            }
            case Z_AXIS: {
                value = side == EnumFacing.EAST || side == EnumFacing.WEST;
                break;
            }
            case SLOPE_NORTH: {
                value = side == EnumFacing.UP || side == EnumFacing.DOWN;
                break;
            }
            case SLOPE_EAST: {
                value = side == EnumFacing.UP || side == EnumFacing.DOWN;
                break;
            }
            case SLOPE_SOUTH: {
                value = side == EnumFacing.UP || side == EnumFacing.DOWN;
                break;
            }
            case SLOPE_WEST: {
                value = side == EnumFacing.UP || side == EnumFacing.DOWN;
                break;
            }
            case DIAGONAL_LEFT: {
                value = side != EnumFacing.UP && side != EnumFacing.DOWN;
                break;
            }
            case DIAGONAL_RIGHT: {
                value = side != EnumFacing.UP && side != EnumFacing.DOWN;
            }
        }
        return value;
    }

    private void playSound(World world, BlockPos position, EntityPlayer player) {
        SoundType soundtype = world.func_180495_p(position).func_177230_c().func_185467_w();
        world.func_184133_a(player, position, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
    }

    public String toString() {
        return "Item variant of : " + ((Slab)this.field_150939_a).getName();
    }
}

