/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import org.apache.commons.lang3.StringUtils;
import tt.betterslabsmod.blocks.slabs.Slab;
import tt.betterslabsmod.items.ItemSlab;
import tt.betterslabsmod.main.BetterSlabsMod;
import tt.betterslabsmod.options.Options;
import tt.betterslabsmod.utils.Pair;

public class RegistryMap
extends LinkedHashMap<String, Pair<Slab, ItemSlab>> {
    private RegistryMap() {
    }

    public static RegistryMap create() {
        return new RegistryMap();
    }

    public void add(String name, Slab slab, ItemSlab itemForm) {
        this.put(name, Pair.of((Object)slab, (Object)itemForm));
    }

    public Block getSlab(String name) {
        if (Options.isSlabAllowed(name)) {
            return (Block)((Pair)this.get(name)).getFirstElement();
        }
        return Blocks.field_150350_a;
    }

    public Item getSlabInItemForm(String name) {
        if (name.contains("facing")) {
            name = StringUtils.substringBefore((String)name, (String)"facing") + "slab";
        }
        if (Options.isSlabAllowed(name)) {
            return (Item)((Pair)this.get(name)).getSecondElement();
        }
        return Items.field_190931_a;
    }

    public Block getSlabWithReplacement(String name, String replacement, String reason) {
        Block slab = this.getSlab(name);
        if (!slab.equals(Blocks.field_150350_a)) {
            return slab;
        }
        Block replacementSlab = this.getSlab(replacement);
        if (!replacementSlab.equals(Blocks.field_150350_a)) {
            return replacementSlab;
        }
        BetterSlabsMod.log(String.format("%s", name, replacement));
        BetterSlabsMod.log(String.format("%s", reason));
        return Blocks.field_150350_a;
    }

    public Slab getRandomSlab() {
        ArrayList pairs = new ArrayList(this.values());
        return (Slab)((Object)((Pair)pairs.get(new Random().nextInt(pairs.size()))).getFirstElement());
    }
}

