/*
 * Decompiled with CFR 0.152.
 */
package tt.betterslabsmod.utils;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum SlabState implements IStringSerializable
{
    NORTH(0, "north", EnumFacing.SOUTH),
    EAST(1, "east", EnumFacing.WEST),
    SOUTH(2, "south", EnumFacing.NORTH),
    WEST(3, "west", EnumFacing.EAST),
    DOWN(4, "down", EnumFacing.UP),
    UP(5, "up", EnumFacing.DOWN),
    X_AXIS(6, "x_axis"),
    Y_AXIS(7, "y_axis"),
    Z_AXIS(8, "z_axis"),
    SLOPE_NORTH(9, "slope_north"),
    SLOPE_EAST(10, "slope_east"),
    SLOPE_SOUTH(11, "slope_south"),
    SLOPE_WEST(12, "slope_west"),
    DIAGONAL_LEFT(13, "diagonal_left"),
    DIAGONAL_RIGHT(14, "diagonal_right");

    public static final String NAME = "slab_state";
    private int stateID;
    private String stateName;
    private EnumFacing oppositeSide;

    private SlabState(int stateID_, String stateName_) {
        this(stateID_, stateName_, null);
    }

    private SlabState(@Nullable int stateID_, String stateName_, EnumFacing oppositeSide_) {
        this.stateID = stateID_;
        this.stateName = stateName_;
        this.oppositeSide = oppositeSide_;
    }

    public int getID() {
        return this.stateID;
    }

    public String func_176610_l() {
        return this.stateName;
    }

    public boolean isOppositeSide(EnumFacing side) {
        return side == this.oppositeSide;
    }

    public static SlabState getAxisFromSide(EnumFacing side) {
        return side == EnumFacing.DOWN || side == EnumFacing.UP ? Y_AXIS : (side == EnumFacing.NORTH || side == EnumFacing.SOUTH ? Z_AXIS : X_AXIS);
    }

    public static SlabState getStateFromSide(EnumFacing side) {
        switch (side) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case WEST: {
                return EAST;
            }
            case DOWN: {
                return UP;
            }
            case UP: {
                return DOWN;
            }
        }
        return DOWN;
    }

    public static boolean isVanilla(SlabState state) {
        return state.getID() == 4 || state.getID() == 5;
    }

    public static boolean isVertical(SlabState state) {
        return state.getID() <= 3;
    }

    public boolean isSlope() {
        return this.stateID >= 9 && this.stateID <= 12;
    }

    public boolean isAxis() {
        return this.stateID >= 6 && this.stateID <= 8;
    }

    public boolean isDiagonal() {
        return this.stateID >= 13;
    }

    public static SlabState getSlabStateByID(int stateID) {
        return SlabState.values()[stateID % SlabState.values().length];
    }

    public static boolean isSideSolid(SlabState state, EnumFacing side) {
        return state.oppositeSide == null ? false : side == state.oppositeSide.func_176734_d();
    }
}

