/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import me.ichun.mods.clef.client.render.BakedModelInstrument;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketStopPlayingTrack;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class EventHandlerClient {
    public HashSet<Track> tracksPlaying = new HashSet();
    public TextureAtlasSprite txInstrument;

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Clef.itemInstrument, (int)0, (ModelResourceLocation)new ModelResourceLocation("clef:instrument", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)Clef.blockInstrumentPlayer), (int)0, (ModelResourceLocation)new ModelResourceLocation("clef:block_instrument_player", "inventory"));
    }

    @SubscribeEvent
    public void onTextureStitchedPre(TextureStitchEvent.Pre event) {
        this.txInstrument = Minecraft.func_71410_x().func_147117_R().func_174942_a(new ResourceLocation("clef", "items/instrument"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)this.txInstrument, (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.empty()));
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("clef:instrument", "inventory"), (Object)new BakedModelInstrument((ImmutableList<BakedQuad>)builder.build(), this.txInstrument, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf(new HashMap()), null, null));
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc;
        if (event.phase == TickEvent.Phase.END && !(mc = Minecraft.func_71410_x()).func_147113_T()) {
            Iterator<Track> ite = this.tracksPlaying.iterator();
            while (ite.hasNext()) {
                Track track = ite.next();
                if (track.update()) continue;
                ite.remove();
            }
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Minecraft.func_71410_x().func_152344_a(this::disconnectFromServer);
    }

    public void disconnectFromServer() {
        this.tracksPlaying.clear();
        AbcLibrary.requestedABCFromServer.clear();
        InstrumentLibrary.requestedInstrumentsFromServer.clear();
    }

    public void addTrack(Track track) {
        this.tracksPlaying.remove(track);
        if (track.hasObjectsPlaying() && track.playing) {
            this.tracksPlaying.add(track);
        }
    }

    public Track findTrackByBand(String bandName) {
        for (Track track : this.tracksPlaying) {
            if (!track.getBandName().equalsIgnoreCase(bandName)) continue;
            return track;
        }
        return null;
    }

    public Track getTrackPlayedByPlayer(EntityPlayer player) {
        for (Track track : this.tracksPlaying) {
            if (!track.players.containsKey(player) && !track.playersNames.contains(player.func_70005_c_())) continue;
            return track;
        }
        return null;
    }

    @SubscribeEvent
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack is = ItemInstrument.getUsableInstrument((EntityLivingBase)event.getEntityPlayer());
        if (!is.func_190926_b() && (event.getEntityPlayer().func_184614_ca().func_190926_b() || event.getEntityPlayer().func_184592_cb().func_190926_b())) {
            this.stopPlayingTrack(event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack is = ItemInstrument.getUsableInstrument((EntityLivingBase)event.getEntityPlayer());
        if (!is.func_190926_b() && (event.getEntityPlayer().func_184614_ca().func_190926_b() || event.getEntityPlayer().func_184592_cb().func_190926_b())) {
            this.stopPlayingTrack(event.getEntityPlayer());
        }
    }

    public void stopPlayingTrack(EntityPlayer player) {
        Track track = this.getTrackPlayedByPlayer(player);
        if (track != null) {
            Clef.channel.sendToServer((AbstractPacket)new PacketStopPlayingTrack(track.getId()));
        }
    }
}

