/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.client.model.item.ModelBaseWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelInstrument
implements IBakedModel {
    private final ImmutableList<BakedQuad> quads;
    private final TextureAtlasSprite particle;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final Instrument instrument;
    public final ResourceLocation instTx;

    public BakedModelInstrument(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Instrument instrument, ResourceLocation instTx) {
        this.quads = quads;
        this.particle = particle;
        this.transforms = transforms;
        this.instrument = instrument;
        this.instTx = instTx;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideListHandler.INSTANCE;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            if (this.instrument != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.instTx);
            }
            return this.quads;
        }
        return ImmutableList.of();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        if (this.instrument != null) {
            HashMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
            map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, new TRSRTransformation(new Vector3f(1.0f, 0.0f, 1.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 180.0f, 0.0f)), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f()));
            map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, new TRSRTransformation(new Vector3f(0.1f, 0.0f + ((float)this.instrument.handImg.getHeight() <= 16.0f ? 0.0f : MathHelper.func_76131_a((float)((float)this.instrument.info.activeHandPosition[1]), (float)-0.3f, (float)0.3f)), 0.025f - ((float)this.instrument.handImg.getWidth() <= 16.0f ? 0.0f : MathHelper.func_76131_a((float)((float)this.instrument.info.activeHandPosition[0]), (float)-0.5f, (float)0.5f))), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 80.0f, 0.0f)), new Vector3f(-1.0f, 1.0f, 1.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f))));
            map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, new TRSRTransformation(new Vector3f(-0.1f, 0.0f + ((float)this.instrument.handImg.getHeight() <= 16.0f ? 0.0f : MathHelper.func_76131_a((float)((float)this.instrument.info.activeHandPosition[1]), (float)-0.3f, (float)0.3f)), 1.0f - ((float)this.instrument.handImg.getWidth() <= 16.0f ? 0.0f : MathHelper.func_76131_a((float)((float)this.instrument.info.activeHandPosition[0]), (float)-0.5f, (float)0.5f))), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 80.0f, 0.0f)), new Vector3f(1.0f, 1.0f, 1.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f))));
            ImmutableMap transforms = ImmutableMap.copyOf(map);
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)(ModelBaseWrapper.isEntityRender((ItemCameraTransforms.TransformType)type) ? this.instrument.handModel : this.instrument.iconModel), (ImmutableMap)transforms, (ItemCameraTransforms.TransformType)type);
        }
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
    }

    private static final class ItemOverrideListHandler
    extends ItemOverrideList {
        private static final ItemOverrideListHandler INSTANCE = new ItemOverrideListHandler();

        private ItemOverrideListHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                Instrument instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"));
                if (instrument != null) {
                    instrument.setupModels();
                    return instrument.iconModel;
                }
                InstrumentLibrary.requestInstrument(tag.func_74779_i("itemName"), null);
            }
            return originalModel;
        }
    }
}

