/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketInstrumentPlayerInfo
extends AbstractPacket {
    public ArrayList<String> abc_md5s;
    public String bandName;
    public boolean syncPlay;
    public boolean syncTrack;
    public int repeat;
    public boolean shuffle;
    public BlockPos pos;

    public PacketInstrumentPlayerInfo() {
    }

    public PacketInstrumentPlayerInfo(ArrayList<String> abc, String bandName, boolean syncPlay, boolean syncTrack, int repeat, boolean shuffle, BlockPos pos) {
        this.abc_md5s = abc;
        this.bandName = bandName;
        this.syncPlay = syncPlay;
        this.syncTrack = syncTrack;
        this.repeat = repeat;
        this.shuffle = shuffle;
        this.pos = pos;
    }

    public void writeTo(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        buf.writeInt(this.abc_md5s.size());
        for (String s : this.abc_md5s) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.bandName);
        buf.writeBoolean(this.syncPlay);
        buf.writeBoolean(this.syncTrack);
        buf.writeInt(this.repeat);
        buf.writeBoolean(this.shuffle);
        pb.func_179255_a(this.pos);
    }

    public void readFrom(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.abc_md5s = new ArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.abc_md5s.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        this.bandName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.syncPlay = buf.readBoolean();
        this.syncTrack = buf.readBoolean();
        this.repeat = buf.readInt();
        this.shuffle = buf.readBoolean();
        this.pos = pb.func_179259_c();
    }

    public void execute(Side side, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_175625_s(this.pos);
        if (te instanceof TileEntityInstrumentPlayer) {
            TileEntityInstrumentPlayer instrumentPlayer = (TileEntityInstrumentPlayer)te;
            instrumentPlayer.tracks.clear();
            for (String s : this.abc_md5s) {
                TrackFile track = AbcLibrary.getTrack(s);
                if (track == null) {
                    instrumentPlayer.pending_md5s = this.abc_md5s;
                    Clef.channel.sendTo((AbstractPacket)new PacketRequestFile(s, false), player);
                    continue;
                }
                instrumentPlayer.tracks.add(track);
            }
            instrumentPlayer.bandName = this.bandName;
            instrumentPlayer.syncPlay = this.syncPlay;
            instrumentPlayer.syncTrack = this.syncTrack;
            instrumentPlayer.repeat = this.repeat;
            instrumentPlayer.shuffle = this.shuffle;
            instrumentPlayer.func_70296_d();
            IBlockState state = player.field_70170_p.func_180495_p(this.pos);
            player.field_70170_p.func_184138_a(this.pos, state, state, 3);
        }
    }

    public Side receivingSide() {
        return Side.SERVER;
    }
}

