/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Map;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayingTracks
extends AbstractPacket {
    public Track[] tracks;

    public PacketPlayingTracks() {
    }

    public PacketPlayingTracks(Track ... tracks) {
        this.tracks = tracks;
    }

    public void writeTo(ByteBuf buf) {
        PacketBuffer buff = new PacketBuffer(buf);
        buf.writeInt(this.tracks.length);
        for (Track track : this.tracks) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)track.getId());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)track.getBandName());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)track.getMd5());
            buf.writeBoolean(track.playing);
            buf.writeInt(track.playProg);
            buf.writeInt(track.players.size());
            for (EntityPlayer entityPlayer : track.players.keySet()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entityPlayer.func_70005_c_());
            }
            buf.writeInt(track.instrumentPlayers.size());
            for (Map.Entry entry : track.instrumentPlayers.entrySet()) {
                buf.writeInt(((Integer)entry.getKey()).intValue());
                buf.writeInt(((HashSet)entry.getValue()).size());
                for (BlockPos pos : (HashSet)entry.getValue()) {
                    buff.func_179255_a(pos);
                }
            }
            buf.writeInt(track.zombies.size());
            for (Integer n : track.zombies) {
                buf.writeInt(n.intValue());
            }
        }
    }

    public void readFrom(ByteBuf buf) {
        PacketBuffer buff = new PacketBuffer(buf);
        this.tracks = new Track[buf.readInt()];
        for (int i = 0; i < this.tracks.length; ++i) {
            int x;
            String md5;
            String id = ByteBufUtils.readUTF8String((ByteBuf)buf);
            String band = ByteBufUtils.readUTF8String((ByteBuf)buf);
            TrackFile file = AbcLibrary.getTrack(md5 = ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.tracks[i] = new Track(id, band, md5, file != null ? file.track : null, true);
            this.tracks[i].playing = buf.readBoolean();
            this.tracks[i].playProg = buf.readInt();
            int playerCount = buf.readInt();
            for (x = 0; x < playerCount; ++x) {
                this.tracks[i].addPlayer(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            playerCount = buf.readInt();
            for (x = 0; x < playerCount; ++x) {
                int key = buf.readInt();
                int count = buf.readInt();
                HashSet<BlockPos> poses = new HashSet<BlockPos>();
                for (int k = 0; k < count; ++k) {
                    poses.add(buff.func_179259_c());
                }
                this.tracks[i].instrumentPlayers.put(key, poses);
            }
            playerCount = buf.readInt();
            for (x = 0; x < playerCount; ++x) {
                this.tracks[i].zombies.add(buf.readInt());
            }
        }
    }

    public void execute(Side side, EntityPlayer player) {
        for (int i = 0; i < this.tracks.length; ++i) {
            Clef.eventHandlerClient.addTrack(this.tracks[i]);
        }
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }
}

