/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.ichun.mods.clef.client.gui.GuiPlayTrack;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.packet.PacketFileFragment;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.util.abc.AbcParser;
import me.ichun.mods.clef.common.util.abc.TrackFile;
import me.ichun.mods.clef.common.util.abc.play.Track;
import me.ichun.mods.clef.common.util.abc.play.components.TrackInfo;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.IOUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;

public class AbcLibrary {
    public static ArrayList<TrackFile> tracks = new ArrayList();
    public static HashSet<String> requestedABCFromServer = new HashSet();
    public static HashSet<String> requestedABCFromPlayers = new HashSet();
    public static HashMap<String, Track> tracksWaitingForTrackInfo = new HashMap();

    public static void init() {
        tracks.clear();
        File defaultAbc = new File(Clef.getResourceHelper().abcDir, "files.extracted");
        if (!defaultAbc.exists()) {
            try (InputStream in2 = Clef.class.getResourceAsStream("/abc.zip");
                 ZipInputStream zipStream = new ZipInputStream(in2);){
                ZipEntry entry;
                int extractCount = 0;
                while ((entry = zipStream.getNextEntry()) != null) {
                    int len;
                    File file = new File(Clef.getResourceHelper().abcDir, entry.getName());
                    if (file.exists() && file.length() > 3L) continue;
                    FileOutputStream out = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((len = zipStream.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.close();
                    ++extractCount;
                }
                if (extractCount > 0) {
                    Clef.LOGGER.info((Object)("Extracted " + Integer.toString(extractCount) + (extractCount == 1 ? " file" : " files from mod zip.")));
                }
            }
            catch (IOException in2) {
                // empty catch block
            }
        }
        Clef.LOGGER.info((Object)"Loading abc files");
        Clef.LOGGER.info((Object)("Loaded " + AbcLibrary.readAbcs(Clef.getResourceHelper().abcDir, tracks) + " abc files"));
        if (tracks.isEmpty()) {
            TrackInfo track = new TrackInfo();
            track.setTitle("You have no tracks");
            track.setFileTitle("You have no tracks");
            track.trackLength = 10;
            tracks.add(new TrackFile(track, new File(Clef.getResourceHelper().abcDir, "You have no tracks.abc"), ""));
        }
    }

    private static int readAbcs(File dir, ArrayList<TrackFile> tracks) {
        int trackCount = 0;
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                trackCount += AbcLibrary.readAbcs(file, tracks);
                continue;
            }
            if (!AbcLibrary.readAbc(file, tracks)) continue;
            ++trackCount;
        }
        return trackCount;
    }

    public static boolean readAbc(File file, ArrayList<TrackFile> tracks) {
        if (file.exists() && file.getName().endsWith(".abc")) {
            TrackInfo track;
            String md5 = IOUtil.getMD5Checksum((File)file);
            if (!(tracks == AbcLibrary.tracks && AbcLibrary.hasTrack(md5) || (track = AbcParser.parse(file)) == null)) {
                tracks.add(new TrackFile(track, file, md5));
                Collections.sort(tracks);
                if (FMLCommonHandler.instance().getEffectiveSide().isServer() && tracksWaitingForTrackInfo.containsKey(md5)) {
                    tracksWaitingForTrackInfo.get(md5).setTrack(md5, track);
                    tracksWaitingForTrackInfo.remove(md5);
                }
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void reloadTracks(GuiPlayTrack gui) {
        ArrayList<TrackFile> tracks = new ArrayList<TrackFile>();
        Clef.LOGGER.info((Object)"Reloading abc files");
        Clef.LOGGER.info((Object)("Reloaded " + AbcLibrary.readAbcs(Clef.getResourceHelper().abcDir, tracks) + " abc files"));
        if (tracks.isEmpty()) {
            TrackInfo track = new TrackInfo();
            track.setTitle("You have no tracks");
            track.setFileTitle("You have no tracks");
            track.trackLength = 10;
            tracks.add(new TrackFile(track, new File(Clef.getResourceHelper().abcDir, "You have no tracks.abc"), ""));
        }
        AbcLibrary.tracks = tracks;
        gui.tracks = tracks;
        gui.index = -1;
        gui.doneTimeout = 20;
        gui.func_73866_w_();
    }

    public static boolean hasTrack(String md5) {
        return AbcLibrary.getTrack(md5) != null;
    }

    public static TrackFile getTrack(String md5) {
        for (TrackFile track : tracks) {
            if (!track.md5.equals(md5)) continue;
            return track;
        }
        return null;
    }

    public static void playAbc(String md5, String bandName, boolean syncPlay, boolean syncTrack, EntityPlayer player) {
        Track playerTrack;
        Track track;
        TrackFile file = AbcLibrary.getTrack(md5);
        if (!bandName.isEmpty()) {
            track = Clef.eventHandlerServer.findTrackByBand(bandName);
            if (track == null && md5.isEmpty()) {
                return;
            }
            Track track1 = track;
            if (track == null || !syncTrack) {
                track = new Track(RandomStringUtils.randomAscii((int)20), bandName, md5, file != null ? file.track : null, false);
            }
            if (syncPlay && track1 != null) {
                track.playAtProgress(track1.playProg);
            }
        } else {
            if (md5.isEmpty()) {
                return;
            }
            track = new Track(RandomStringUtils.randomAscii((int)20), bandName, md5, file != null ? file.track : null, false);
        }
        if (file == null && requestedABCFromPlayers.add(md5)) {
            if (track.getTrack() == null) {
                tracksWaitingForTrackInfo.put(md5, track);
            }
            Clef.channel.sendTo((AbstractPacket)new PacketRequestFile(md5, false), player);
        }
        if ((playerTrack = Clef.eventHandlerServer.getTrackPlayedByPlayer(player)) != null) {
            playerTrack.players.remove(player);
            if (!playerTrack.hasObjectsPlaying()) {
                playerTrack.stop();
            }
            Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(playerTrack));
        }
        Clef.eventHandlerServer.tracksPlaying.add(track);
        track.players.put(player, 0);
        if (track.getTrack() != null) {
            Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(track));
        }
    }

    public static void startPlayingTrack(EntityPlayer player, Track ... tracks) {
        Clef.channel.sendTo((AbstractPacket)new PacketPlayingTracks(tracks), player);
    }

    public static void sendAbc(String md5, EntityPlayer player) {
        if (md5.isEmpty()) {
            return;
        }
        TrackFile track = AbcLibrary.getTrack(md5);
        if (track != null) {
            if (!track.file.exists()) {
                Clef.LOGGER.warn((Object)("Unable to send track " + track.file.getName() + ". File is no longer on disk."));
                return;
            }
            try (FileInputStream fis = new FileInputStream(track.file);){
                int fileSize;
                if (fileSize > 10000000) {
                    Clef.LOGGER.warn((Object)("Unable to send track " + track.file.getName() + ". It is above the size limit!"));
                    return;
                }
                if (fileSize == 0) {
                    Clef.LOGGER.warn((Object)("Unable to send track " + track.file.getName() + ". The file is empty!"));
                    return;
                }
                Clef.LOGGER.info((Object)("Sending track " + track.file.getName() + " to " + (player == null ? "the server" : player.func_70005_c_())));
                int packetsToSend = (int)Math.ceil((float)fileSize / 32000.0f);
                int packetCount = 0;
                for (fileSize = (int)track.file.length(); fileSize > 0; fileSize -= 32000) {
                    byte[] fileBytes = new byte[fileSize > 32000 ? 32000 : fileSize];
                    fis.read(fileBytes);
                    if (player != null) {
                        Clef.channel.sendTo((AbstractPacket)new PacketFileFragment(track.file.getName(), packetsToSend, packetCount, fileSize > 32000 ? 32000 : fileSize, fileBytes), player);
                    } else {
                        Clef.channel.sendToServer((AbstractPacket)new PacketFileFragment(track.file.getName(), packetsToSend, packetCount, fileSize > 32000 ? 32000 : fileSize, fileBytes));
                    }
                    ++packetCount;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void handleReceivedFile(String fileName, byte[] fileData, Side side) {
        File dir = new File(Clef.getResourceHelper().abcDir, "received");
        File file = new File(dir, fileName);
        try {
            dir.mkdirs();
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(fileData);
            fos.close();
            Clef.LOGGER.info((Object)("Received " + fileName + ". Reading."));
            AbcLibrary.readAbc(file, tracks);
            if (side.isServer()) {
                requestedABCFromPlayers.remove(fileName.substring(0, fileName.length() - 4));
            } else {
                requestedABCFromServer.remove(fileName.substring(0, fileName.length() - 4));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

