/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.abc.play;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.item.ItemInstrument;
import me.ichun.mods.clef.common.packet.PacketPlayingTracks;
import me.ichun.mods.clef.common.packet.PacketRequestFile;
import me.ichun.mods.clef.common.tileentity.TileEntityInstrumentPlayer;
import me.ichun.mods.clef.common.util.abc.AbcLibrary;
import me.ichun.mods.clef.common.util.abc.play.components.Note;
import me.ichun.mods.clef.common.util.abc.play.components.TrackInfo;
import me.ichun.mods.clef.common.util.instrument.Instrument;
import me.ichun.mods.clef.common.util.instrument.InstrumentLibrary;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Track {
    private final String id;
    private final String band;
    private String md5;
    private TrackInfo track;
    public boolean isRemote;
    public int playProg;
    public boolean playing = true;
    public int timeToSilence = 0;
    public HashMap<Integer, HashSet<BlockPos>> instrumentPlayers = new HashMap();
    public HashSet<String> playersNames = new HashSet();
    public HashMap<EntityPlayer, Integer> players = new HashMap();
    public HashSet<Integer> zombies = new HashSet();

    public Track(String id, String band, String md5, @Nullable TrackInfo track, boolean isRemote) {
        this.md5 = md5;
        this.id = id;
        this.band = band;
        this.track = track;
        this.isRemote = isRemote;
    }

    public void addPlayer(String playerName) {
        this.playersNames.add(playerName);
    }

    public String getId() {
        return this.id;
    }

    public String getBandName() {
        return this.band;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setTrack(String md5, TrackInfo track) {
        this.md5 = md5;
        this.track = track;
        if (!this.isRemote) {
            Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(this));
        }
    }

    public TrackInfo getTrack() {
        return this.track;
    }

    public boolean update() {
        if (this.track == null) {
            if (!this.isRemote) {
                return true;
            }
            if (this.shouldRequestTrack() && AbcLibrary.requestedABCFromServer.add(this.md5)) {
                Clef.channel.sendToServer((AbstractPacket)new PacketRequestFile(this.md5, false));
            }
            ++this.playProg;
            return true;
        }
        if (!this.playing || this.playProg > this.track.trackLength) {
            return false;
        }
        if (this.isRemote) {
            if (this.playProg == 0 && Clef.config.showRecordPlayingMessageForTracks == 1) {
                this.showNowPlaying();
            }
            if (this.timeToSilence > 0) {
                --this.timeToSilence;
            }
            this.findPlayers();
            if (this.track.notes.containsKey(this.playProg)) {
                EntityPlayer mcPlayer = iChunUtil.proxy.getMcPlayer();
                if (mcPlayer == null) {
                    return false;
                }
                Iterator<Map.Entry<EntityPlayer, Integer>> playerIte = this.players.entrySet().iterator();
                while (playerIte.hasNext()) {
                    Map.Entry<EntityPlayer, Integer> e = playerIte.next();
                    EntityPlayer player = e.getKey();
                    if (player.func_70089_S() && (double)player.func_70032_d((Entity)mcPlayer) < 48.0) {
                        NBTTagCompound tag;
                        ItemStack is = ItemInstrument.getUsableInstrument((EntityLivingBase)player);
                        if (is.func_190926_b() || (tag = is.func_77978_p()) == null) continue;
                        Instrument instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"));
                        if (instrument != null) {
                            HashSet<Note> notes = this.track.notes.get(this.playProg);
                            for (Note note : notes) {
                                int time = note.playNote(this, this.playProg, instrument, player);
                                if (time <= this.timeToSilence || note.key == -1) continue;
                                this.timeToSilence = time;
                            }
                            continue;
                        }
                        InstrumentLibrary.requestInstrument(tag.func_74779_i("itemName"), null);
                        continue;
                    }
                    this.playersNames.add(player.func_70005_c_());
                    playerIte.remove();
                }
                HashSet<BlockPos> poses = this.instrumentPlayers.get(mcPlayer.func_130014_f_().field_73011_w.getDimension());
                if (poses != null) {
                    for (BlockPos pos : poses) {
                        TileEntity te;
                        if (!(mcPlayer.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 48.0) || !((te = mcPlayer.field_70170_p.func_175625_s(pos)) instanceof TileEntityInstrumentPlayer)) continue;
                        TileEntityInstrumentPlayer player = (TileEntityInstrumentPlayer)te;
                        for (int i = 0; i < 9; ++i) {
                            Instrument instrument;
                            ItemStack is = player.func_70301_a(i);
                            if (is.func_77973_b() != Clef.itemInstrument || is.func_77978_p() == null || (instrument = InstrumentLibrary.getInstrumentByName(is.func_77978_p().func_74779_i("itemName"))) == null) continue;
                            HashSet<Note> notes = this.track.notes.get(this.playProg);
                            for (Note note : notes) {
                                note.playNote(this, this.playProg, instrument, player.func_174877_v());
                            }
                        }
                    }
                }
                for (Integer i : this.zombies) {
                    NBTTagCompound tag;
                    ItemStack is;
                    Entity ent = mcPlayer.field_70170_p.func_73045_a(i.intValue());
                    if (!(ent instanceof EntityZombie) || !ent.func_70089_S() || !((double)mcPlayer.func_70032_d(ent) < 48.0) || (is = ItemInstrument.getUsableInstrument((EntityLivingBase)((EntityZombie)ent))).func_190926_b() || (tag = is.func_77978_p()) == null) continue;
                    Instrument instrument = InstrumentLibrary.getInstrumentByName(tag.func_74779_i("itemName"));
                    if (instrument != null) {
                        HashSet<Note> notes = this.track.notes.get(this.playProg);
                        for (Note note : notes) {
                            note.playNote(this, this.playProg, instrument, ent);
                        }
                        continue;
                    }
                    InstrumentLibrary.requestInstrument(tag.func_74779_i("itemName"), null);
                }
            }
        } else {
            boolean update = false;
            Iterator<Map.Entry<EntityPlayer, Integer>> playerIte = this.players.entrySet().iterator();
            while (playerIte.hasNext()) {
                Map.Entry<EntityPlayer, Integer> e = playerIte.next();
                EntityPlayer player = e.getKey();
                if (player.func_70089_S()) {
                    Instrument instrument;
                    e.setValue(e.getValue() + 1);
                    ItemStack is = ItemInstrument.getUsableInstrument((EntityLivingBase)player);
                    if (!is.func_190926_b() && (instrument = InstrumentLibrary.getInstrumentByName(is.func_77978_p().func_74779_i("itemName"))) != null) {
                        e.setValue(0);
                    }
                } else {
                    e.setValue(10000000);
                }
                if (e.getValue() <= 100) continue;
                update = true;
                playerIte.remove();
            }
            Iterator<Integer> z = this.zombies.iterator();
            while (z.hasNext()) {
                Integer i = z.next();
                if (!(Math.random() < (double)0.001f)) continue;
                z.remove();
                update = true;
            }
            if (update) {
                if (!this.hasObjectsPlaying()) {
                    this.stop();
                }
                Clef.channel.sendToAll((AbstractPacket)new PacketPlayingTracks(this));
            }
        }
        ++this.playProg;
        return true;
    }

    public void stop() {
        this.playing = false;
    }

    public void playAtProgress(int i) {
        this.playProg = i;
    }

    public boolean hasObjectsPlaying() {
        for (HashSet<BlockPos> list : this.instrumentPlayers.values()) {
            if (list.isEmpty()) continue;
            return true;
        }
        return !this.playersNames.isEmpty() || !this.players.isEmpty() || !this.zombies.isEmpty();
    }

    public boolean equals(Object o) {
        return o instanceof Track && this.id.equals(((Track)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @SideOnly(value=Side.CLIENT)
    public void findPlayers() {
        Iterator<String> ite = this.playersNames.iterator();
        while (ite.hasNext()) {
            EntityPlayer player;
            String s = ite.next();
            if (Minecraft.func_71410_x().field_71441_e == null || (player = Minecraft.func_71410_x().field_71441_e.func_72924_a(s)) == null || !player.func_70089_S()) continue;
            this.players.put(player, 0);
            ite.remove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void showNowPlaying() {
        Minecraft.func_71410_x().field_71456_v.func_73833_a(this.track.getTitle());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRequestTrack() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return false;
        }
        HashSet<BlockPos> poses = this.instrumentPlayers.get(world.field_73011_w.getDimension());
        if (poses != null) {
            for (BlockPos pos : poses) {
                if (!(Minecraft.func_71410_x().field_71439_g.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 48.0)) continue;
                return true;
            }
        }
        for (String s : this.playersNames) {
            EntityPlayer player;
            if (Minecraft.func_71410_x().field_71441_e == null || (player = Minecraft.func_71410_x().field_71441_e.func_72924_a(s)) == null || !player.func_70089_S()) continue;
            return true;
        }
        for (Integer i : this.zombies) {
            Entity ent;
            if (Minecraft.func_71410_x().field_71441_e == null || (ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(i.intValue())) == null || !ent.func_70089_S()) continue;
            return true;
        }
        return false;
    }
}

