/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.clef.common.util.instrument;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import me.ichun.mods.clef.client.render.BakedModelInstrument;
import me.ichun.mods.clef.common.Clef;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentPackInfo;
import me.ichun.mods.clef.common.util.instrument.component.InstrumentTuning;
import me.ichun.mods.ichunutil.client.render.TextureAtlasSpriteBufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Instrument
implements Comparable<Instrument> {
    public final InstrumentInfo info;
    public final BufferedImage iconImg;
    public final BufferedImage handImg;
    public InstrumentTuning tuning;
    public InstrumentPackInfo packInfo;
    @SideOnly(value=Side.CLIENT)
    public BakedModelInstrument iconModel;
    @SideOnly(value=Side.CLIENT)
    public BakedModelInstrument handModel;

    public Instrument(InstrumentInfo info, BufferedImage iconImg, BufferedImage handImg) {
        this.info = info;
        this.iconImg = iconImg;
        this.handImg = handImg;
    }

    public boolean hasAvailableKey(int key) {
        return this.tuning.keyToTuningMap.containsKey(key) && this.tuning.keyToTuningMap.get(key).streamsLength() > 0;
    }

    @Override
    public int compareTo(Instrument o) {
        if (this.packInfo.packName.toLowerCase().equals(o.packInfo.packName.toLowerCase())) {
            return this.info.shortdescription.toLowerCase().compareTo(o.info.shortdescription.toLowerCase());
        }
        return this.packInfo.packName.toLowerCase().compareTo(o.packInfo.packName.toLowerCase());
    }

    public ByteArrayOutputStream getAsBAOS() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream out = new ZipOutputStream(baos);
            out.setLevel(9);
            if (this.packInfo != null) {
                String desc = this.packInfo.description;
                this.packInfo.description = this.packInfo.description.concat(" - This pack is a single instrument from the main pack.");
                out.putNextEntry(new ZipEntry("info.cii"));
                byte[] data = new Gson().toJson((Object)this.packInfo).getBytes();
                out.write(data, 0, data.length);
                out.closeEntry();
                this.packInfo.description = desc;
            }
            out.putNextEntry(new ZipEntry("items/"));
            out.putNextEntry(new ZipEntry("items/instruments/"));
            out.putNextEntry(new ZipEntry("items/instruments/" + this.info.itemName + ".instrument"));
            byte[] data = new Gson().toJson((Object)this.info).getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            out.putNextEntry(new ZipEntry("items/instruments/" + this.info.inventoryIcon));
            ImageIO.write((RenderedImage)this.iconImg, "png", out);
            out.closeEntry();
            if (!this.info.inventoryIcon.equals(this.info.activeImage)) {
                out.putNextEntry(new ZipEntry("items/instruments/" + this.info.activeImage));
                ImageIO.write((RenderedImage)this.handImg, "png", out);
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry("sfx/"));
            out.putNextEntry(new ZipEntry("sfx/instruments/"));
            out.putNextEntry(new ZipEntry("sfx/instruments/" + this.info.kind + "/"));
            out.putNextEntry(new ZipEntry("sfx/instruments/" + this.info.kind + "/tuning.config"));
            data = new Gson().toJson((Object)this.tuning).getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            for (Map.Entry<String, byte[]> e : this.tuning.audioToOutputStream.entrySet()) {
                out.putNextEntry(new ZipEntry("sfx/instruments/" + this.info.kind + "/" + e.getKey()));
                out.write(e.getValue());
                out.closeEntry();
            }
            out.close();
            return baos;
        }
        catch (Exception e) {
            Clef.LOGGER.warn((Object)("Error creating instrument package: " + this.info.itemName));
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupModels() {
        if (this.iconModel == null && this.handModel == null) {
            Minecraft mc = Minecraft.func_71410_x();
            ResourceLocation iconRl = new ResourceLocation("clef", "instrument/" + this.info.itemName + "/icon.png");
            ResourceLocation handRl = new ResourceLocation("clef", "instrument/" + this.info.itemName + "/hand.png");
            InstrumentTexture iconTx = new InstrumentTexture(iconRl, this.iconImg);
            InstrumentTexture handTx = new InstrumentTexture(handRl, this.handImg);
            mc.func_110434_K().func_110579_a(iconTx.rl, (ITextureObject)iconTx);
            mc.func_110434_K().func_110579_a(handTx.rl, (ITextureObject)handTx);
            this.iconModel = new BakedModelInstrument(iconTx.quads, (TextureAtlasSprite)iconTx.tasi, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf(new HashMap()), this, iconRl);
            this.handModel = new BakedModelInstrument(handTx.quads, (TextureAtlasSprite)handTx.tasi, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf(new HashMap()), this, handRl);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class InstrumentTexture
    extends AbstractTexture {
        public final ResourceLocation rl;
        public final BufferedImage image;
        public ImmutableList<BakedQuad> quads;
        public TextureAtlasSpriteBufferedImage tasi;

        public InstrumentTexture(ResourceLocation rl, BufferedImage image) {
            this.rl = rl;
            int size = Math.max(Math.max(image.getWidth(), image.getHeight()), 16);
            BufferedImage image1 = new BufferedImage(size, size, 2);
            int halfX = (int)Math.floor((double)(size - image.getWidth()) / 2.0);
            int halfY = (int)Math.floor((double)(size - image.getHeight()) / 2.0);
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int clr = image.getRGB(x, y);
                    if (clr == -1) continue;
                    image1.setRGB(halfX + x, halfY + y, clr);
                }
            }
            this.image = image1;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)this.image, (boolean)false, (boolean)false);
            ImmutableList.Builder builder = ImmutableList.builder();
            this.tasi = new TextureAtlasSpriteBufferedImage(this.rl, this.image);
            this.tasi.load(Minecraft.func_71410_x().func_110442_L(), this.rl);
            builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)this.tasi, (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.empty()));
            this.quads = builder.build();
        }
    }
}

