/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched;

import java.awt.Color;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.compatched.CompactRegistry;
import shadows.compatched.ConfigurationHandler;
import shadows.compatched.block.BlockChest;
import shadows.compatched.creativetabs.CreativeTabCompactStorage;
import shadows.compatched.packet.MessageCraftChest;
import shadows.compatched.packet.MessageUpdateBuilder;
import shadows.compatched.util.StorageInfo;
import shadows.placebo.config.Configuration;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.NetworkUtils;

@Mod(value="compatchedstorage")
public class ComPatchedStorage {
    public static final String MODID = "compatchedstorage";
    public static final ItemGroup TAB = new CreativeTabCompactStorage();
    public static final Logger LOGGER = LogManager.getLogger((String)"compatchedstorage");
    public static final RecipeHelper HELPER = new RecipeHelper("compatchedstorage");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("compatchedstorage", "compatchedstorage")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();

    public ComPatchedStorage() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerInteract);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        ConfigurationHandler.configuration = new Configuration(new File(FMLPaths.CONFIGDIR.get().toFile(), "compatchedstorage.cfg"));
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new MessageUpdateBuilder());
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)1, (NetworkUtils.MessageProvider)new MessageCraftChest());
        HELPER.addShaped((Object)CompactRegistry.CHEST_BUILDER, 3, 3, new Object[]{Items.field_151042_j, Blocks.field_150442_at, Items.field_151042_j, Items.field_151042_j, Blocks.field_150486_ae, Items.field_151042_j, Items.field_151042_j, Blocks.field_150442_at, Items.field_151042_j});
        HELPER.addShaped((Object)CompactRegistry.BARREL, 3, 3, new Object[]{Items.field_151042_j, Items.field_151042_j, Items.field_151042_j, Blocks.field_150339_S, Blocks.field_150486_ae, Blocks.field_150339_S, Items.field_151042_j, Items.field_151042_j, Items.field_151042_j});
        HELPER.addShaped((Object)CompactRegistry.FLUID_BARREL, 3, 3, new Object[]{Items.field_151042_j, Blocks.field_150410_aZ, Items.field_151042_j, Blocks.field_150339_S, Items.field_151042_j, Blocks.field_150339_S, Items.field_151042_j, Blocks.field_150410_aZ, Items.field_151042_j});
        ConfigurationHandler.init();
        LootSystem.defaultBlockTable((Block)CompactRegistry.CHEST_BUILDER);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (block instanceof BlockChest && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151045_i) {
            state.func_215687_a(event.getWorld(), event.getPlayer(), event.getHand(), BlockRayTraceResult.func_216352_a(null, null, (BlockPos)event.getPos()));
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    public static int getColorFromHue(int hue) {
        Color color = hue == -1 ? Color.white : Color.getHSBColor((float)hue / 360.0f, 0.5f, 0.5f).brighter();
        return color.getRGB();
    }

    public static int getColorFromNBT(ItemStack stack) {
        StorageInfo info = new StorageInfo(0, 0, 0, null);
        info.deserialize(stack.func_190925_c("BlockEntityTag").func_74775_l("info"));
        return ComPatchedStorage.getColorFromHue(info.getHue());
    }
}

