/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.compatched.ComPatchedStorage;
import shadows.placebo.config.Configuration;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static ItemStack storage;
    public static ItemStack storageBackpack;
    public static ItemStack[] primary;
    public static ItemStack[] secondary;
    public static ItemStack binder;
    public static ItemStack binderBackpack;
    public static float storageModifier;
    public static float primaryModifier;
    public static float secondaryModifier;
    public static float binderModifier;

    public static void init() {
        storage = ConfigurationHandler.getItemFromConfig(configuration, "chestStorage", "builder", "minecraft:chest", "This is used as the first component in the Builder when building a CHEST.");
        storageBackpack = ConfigurationHandler.getItemFromConfig(configuration, "backpackStorage", "builder", "minecraft:white_wool", "This is used as the first component in the Builder when building a BACKPACK.");
        primary = ConfigurationHandler.getItemsFromConfig(configuration, "primaryItem", "builder", new String[]{"minecraft:iron_ingot"}, "These values are used for the first material cost in the chest builder, you can add as many values as you like, it will configure itself to use all of them.");
        secondary = ConfigurationHandler.getItemsFromConfig(configuration, "secondaryItem", "builder", new String[]{"minecraft:iron_bars"}, "These values are used for the second material cost in the chest builder, you can add as many values as you like, it will configure itself to use all of them.");
        binder = ConfigurationHandler.getItemFromConfig(configuration, "chestBinder", "builder", "minecraft:clay_ball", "This is used as the binder material when making a CHEST.");
        binderBackpack = ConfigurationHandler.getItemFromConfig(configuration, "backpackBinder", "builder", "minecraft:string", "This is used as the binder material when making a BACKPACK.");
        storageModifier = configuration.getFloat("storage_modifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        primaryModifier = configuration.getFloat("primary_modifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        secondaryModifier = configuration.getFloat("secondary_modifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        binderModifier = configuration.getFloat("binder_modifier", "builder", 1.0f, 0.0f, 1.0f, "This determines how much of the item is required.");
        configuration.setCategoryComment("builder", "Format for item names is modid:name");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static ItemStack getItemFromConfig(Configuration config, String key, String category, String defaultString, String comment) {
        String itemId;
        String itemName = config.getString(key, category, defaultString, comment);
        String modId = itemName.contains(":") ? itemName.split(":", 2)[0] : "minecraft";
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, itemId = itemName.contains(":") ? itemName.split(":", 2)[1] : itemName));
        if (item == null) {
            ComPatchedStorage.LOGGER.error("Invalid configuration entry {} in {}", (Object)itemName, (Object)key);
        }
        return new ItemStack((IItemProvider)item);
    }

    public static ItemStack[] getItemsFromConfig(Configuration config, String key, String category, String[] defaultItems, String comment) {
        String[] itemNames;
        ArrayList items = Lists.newArrayList();
        for (String itemName : itemNames = config.getStringList(key, category, defaultItems, comment)) {
            String itemId;
            String modId = itemName.contains(":") ? itemName.split(":", 2)[0] : "minecraft";
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, itemId = itemName.contains(":") ? itemName.split(":", 2)[1] : itemName));
            if (item == null) {
                ComPatchedStorage.LOGGER.error("Invalid configuration entry {} in {}", (Object)itemName, (Object)key);
            }
            items.add(new ItemStack((IItemProvider)item));
        }
        return items.toArray(new ItemStack[items.size()]);
    }
}

