/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import shadows.compatched.CompactRegistry;
import shadows.compatched.inventory.ContainerChest;
import shadows.compatched.tileentity.TileEntityChest;
import shadows.compatched.util.EntityUtil;

public class BlockChest
extends HorizontalBlock {
    public static final VoxelShape SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375));

    public BlockChest() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f).harvestLevel(1).harvestTool(ToolType.AXE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)EntityUtil.get2dOrientation((LivingEntity)context.func_195999_j()));
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            if (!player.func_70093_af()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)chest, buf -> ContainerChest.writeChest(buf, chest).func_179255_a(pos));
                return true;
            }
            ItemStack held = player.func_184586_b(hand);
            if (!chest.isRetaining() && !held.func_190926_b() && held.func_77973_b() == Items.field_151045_i) {
                chest.setRetaining(true);
                held.func_190920_e(held.func_190916_E() - 1);
                player.func_145747_a(new TranslationTextComponent("compatchedstorage.msg.retain", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                world.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 1.0f);
                chest.updateBlock();
            }
        }
        return !player.func_70093_af();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityChest();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != this) {
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_149666_a(group, items);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        chest.func_189515_b(stack.func_190925_c("BlockEntityTag"));
        return stack;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntityChest chest;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack((IItemProvider)CompactRegistry.CHEST);
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        TileEntityChest tileEntityChest = chest = te instanceof TileEntityChest ? (TileEntityChest)te : new TileEntityChest();
        if (!chest.isRetaining()) {
            for (int slot = 0; slot < chest.getItems().getSlots(); ++slot) {
                ItemStack s = chest.getItems().getStackInSlot(slot);
                if (s.func_190926_b()) continue;
                stacks.add(s);
            }
            chest.func_189515_b(stack.func_190925_c("BlockEntityTag")).func_82580_o("items");
        } else {
            chest.func_189515_b(stack.func_190925_c("BlockEntityTag"));
        }
        stacks.add(stack);
        return stacks;
    }
}

