/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import shadows.compatched.ComPatchedStorage;
import shadows.compatched.client.gui.elements.GuiSliderHue;
import shadows.compatched.inventory.ContainerChestBuilder;
import shadows.compatched.packet.MessageCraftChest;
import shadows.compatched.packet.MessageUpdateBuilder;
import shadows.compatched.tileentity.TileEntityChestBuilder;
import shadows.compatched.util.RenderUtil;
import shadows.compatched.util.StorageInfo;

public class GuiChestBuilder
extends ContainerScreen<ContainerChestBuilder> {
    public World world;
    public PlayerEntity player;
    public BlockPos pos;
    private Button buttonSubmit;
    private GuiSlider hueSlider;
    private GuiSlider columnSlider;
    private GuiSlider rowSlider;
    public TileEntityChestBuilder builder;
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");

    public GuiChestBuilder(ContainerChestBuilder container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        this.world = container.world;
        this.player = container.player;
        this.pos = container.pos;
        this.builder = container.builder;
        this.field_146999_f = 176;
        this.field_147000_g = 211;
    }

    public void init() {
        super.init();
        this.buttonSubmit = new GuiButtonExt(this.field_147003_i + 5, this.field_147009_r + 8 + 108 - 14, this.field_146999_f - 31, 20, "Build", button -> ComPatchedStorage.CHANNEL.sendToServer((Object)new MessageCraftChest(this.pos, this.builder.getInfo())));
        this.addButton((Widget)this.buttonSubmit);
        int offsetY = 18;
        this.columnSlider = new GuiSlider(this.field_147003_i + 5, this.field_147009_r + offsetY + 22, 150, 20, "", " " + I18n.func_135052_a((String)"compatchedstorage.text.columns", (Object[])new Object[0]), 1.0, 24.0, (double)this.builder.getInfo().getSizeX(), false, true, b -> {}, s -> {
            this.builder.getInfo().setSizeX(s.getValueInt());
            ComPatchedStorage.CHANNEL.sendToServer((Object)new MessageUpdateBuilder(this.builder.getInfo()));
        });
        this.columnSlider.setWidth(this.field_146999_f / 2 - 7);
        this.addButton((Widget)this.columnSlider);
        this.rowSlider = new GuiSlider(this.field_147003_i + this.field_146999_f / 2 + 3, this.field_147009_r + offsetY + 22, 150, 20, "", " " + I18n.func_135052_a((String)"compatchedstorage.text.rows", (Object[])new Object[0]), 1.0, 12.0, (double)this.builder.getInfo().getSizeY(), false, true, b -> {}, s -> {
            this.builder.getInfo().setSizeY(s.getValueInt());
            ComPatchedStorage.CHANNEL.sendToServer((Object)new MessageUpdateBuilder(this.builder.getInfo()));
        });
        this.rowSlider.setWidth(this.field_146999_f / 2 - 7);
        this.addButton((Widget)this.rowSlider);
        this.hueSlider = new GuiSliderHue(this.field_147003_i + 5, this.field_147009_r + offsetY, I18n.func_135052_a((String)"compatchedstorage.text.hue", (Object[])new Object[0]) + " ", -1.0f, 360.0f, this.builder.getInfo().getHue(), s -> {
            this.builder.getInfo().setHue(s.getValueInt());
            ComPatchedStorage.CHANNEL.sendToServer((Object)new MessageUpdateBuilder(this.builder.getInfo()));
        });
        this.hueSlider.setWidth(this.field_146999_f - 10);
        this.addButton((Widget)this.hueSlider);
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.hueSlider.func_212927_b(x, y);
        for (int t = 0; t < StorageInfo.Type.values().length; ++t) {
            StorageInfo.Type type = StorageInfo.Type.values()[t];
            int startX = this.field_147003_i + 26 * t;
            int startY = this.field_147009_r - 26;
            int endX = startX + 26;
            int endY = startY + 26;
            if (!(x >= (double)startX) || !(x <= (double)endX) || !(y >= (double)startY) || !(y <= (double)endY)) continue;
            StorageInfo info = new StorageInfo(this.builder.getInfo().getSizeX(), this.builder.getInfo().getSizeY(), this.builder.getInfo().getHue(), type);
            ComPatchedStorage.CHANNEL.sendToServer((Object)new MessageUpdateBuilder(info));
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.hueSlider.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        this.columnSlider.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        this.rowSlider.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public void render(int mouseX, int mouseY, float k) {
        this.renderBackground();
        super.render(mouseX, mouseY, k);
        if (this.builder != null) {
            ArrayList<String> toolList;
            int endY;
            int endX;
            int startY;
            int startX;
            boolean hoverTooltip = false;
            for (int x = 0; x < 4; ++x) {
                if (x >= this.builder.getInfo().getMaterialCost().size() || this.builder.getInfo().getMaterialCost().get(x) == null) continue;
                ItemStack stack = this.builder.getInfo().getMaterialCost().get(x);
                startX = this.field_147003_i + (this.field_146999_f / 2 - 36) + x * 18;
                startY = this.field_147009_r + 62;
                endX = startX + 18;
                endY = startY + 18;
                if (mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY) {
                    toolList = new ArrayList();
                    toolList.add(stack.func_200301_q().func_150254_d());
                    toolList.add(TextFormatting.AQUA + I18n.func_135052_a((String)"compatchedstorage.text.amountreq", (Object[])new Object[]{stack.func_190916_E()}));
                    GuiUtils.drawHoveringText(toolList, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.font);
                    hoverTooltip = true;
                    break;
                }
                RenderHelper.func_74518_a();
            }
            if (!hoverTooltip) {
                for (int t = 0; t < StorageInfo.Type.values().length; ++t) {
                    StorageInfo.Type type = StorageInfo.Type.values()[t];
                    startX = this.field_147003_i + 26 * t;
                    startY = this.field_147009_r - 26;
                    endX = startX + 26;
                    endY = startY + 26;
                    if (mouseX < startX || mouseX > endX || mouseY < startY || mouseY > endY) continue;
                    toolList = new ArrayList<String>();
                    toolList.add(I18n.func_135052_a((String)type.name, (Object[])new Object[0]));
                    GuiUtils.drawHoveringText(toolList, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.font);
                    hoverTooltip = true;
                    break;
                }
            }
            if (!hoverTooltip) {
                this.func_191948_b(mouseX, mouseY);
            }
        }
    }

    public void func_146976_a(float i, int j, int k) {
        super.func_146979_b(j, k);
        for (StorageInfo.Type type : StorageInfo.Type.values()) {
            if (type.equals((Object)this.builder.getInfo().getType())) continue;
            this.drawTab(type, type.display);
        }
        RenderHelper.func_74518_a();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, 7, 7);
        RenderUtil.renderBackground(this, this.field_147003_i, this.field_147009_r, 162, 95);
        int slotX = this.field_147003_i + this.field_146999_f / 2 - 81;
        int slotY = this.field_147009_r + 7 + 108 + 10;
        RenderUtil.renderSlots(slotX, slotY, 9, 3);
        slotY = slotY + 54 + 4;
        RenderUtil.renderSlots(slotX, slotY, 9, 1);
        slotY = this.field_147009_r + 50 + 12;
        slotX = this.field_147003_i + (this.field_146999_f / 2 - 36);
        RenderUtil.renderSlots(slotX, slotY, 4, 1);
        RenderUtil.renderSlots(slotX, slotY += 20, 4, 1);
        RenderUtil.renderSlots(this.field_147003_i + 5 + this.field_146999_f - 30, this.field_147009_r + 8 + 108 - 13, 1, 1);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        StorageInfo info = this.builder.getInfo();
        if (info == null) {
            return;
        }
        slotY = this.field_147009_r + 50 + 12;
        slotX = this.field_147003_i + (this.field_146999_f / 2 - 36);
        for (int x = 0; x < info.getMaterialCost().size(); ++x) {
            ItemStack stack = info.getMaterialCost().get(x);
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, slotX + 1 + x * 18, slotY + 1);
            RenderHelper.func_74518_a();
        }
        this.font.func_211126_b(this.getTitle().func_150254_d(), (float)(this.field_147003_i + 7), (float)(this.field_147009_r + 7), 0x404040);
        this.drawTab(this.builder.getInfo().getType(), this.builder.getInfo().getType().display);
    }

    private void drawTab(StorageInfo.Type type, ItemStack stack) {
        boolean active = type.ordinal() == this.builder.getInfo().getType().ordinal();
        int i = type.ordinal();
        int j = i * 28;
        int k = 0;
        int l = this.field_147003_i + 26 * i;
        int i1 = this.field_147009_r;
        if (active) {
            k += 32;
        }
        if (i == 5) {
            l = this.field_147003_i + this.field_146999_f - 28;
        } else if (i > 0) {
            l += i;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
        GlStateManager.disableLighting();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        this.blit(l, i1 -= 28, j, k, 28, 32);
        this.blitOffset = 100;
        this.itemRenderer.field_77023_b = 100.0f;
        RenderHelper.func_74520_c();
        GlStateManager.enableRescaleNormal();
        this.itemRenderer.func_180450_b(stack, l += 6, i1 += 8);
        this.itemRenderer.func_175030_a(this.font, stack, l, i1);
        RenderHelper.func_74518_a();
        this.itemRenderer.field_77023_b = 0.0f;
        this.blitOffset = 0;
    }
}

