/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.client.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiSliderHue
extends GuiSlider {
    public GuiSliderHue(int x, int y, String nameIn, float minIn, float maxIn, float defaultValue, GuiSlider.ISlider slider) {
        super(x, y, 150, 20, nameIn, "", (double)minIn, (double)maxIn, (double)defaultValue, false, true, b -> {}, slider);
    }

    protected void renderBg(Minecraft par1Minecraft, int par2, int par3) {
        super.renderBg(par1Minecraft, par2, par3);
        if (this.visible) {
            Color color = this.sliderValue == 0.0 ? Color.WHITE : Color.getHSBColor((float)this.sliderValue, 1.0f, 1.0f);
            GlStateManager.color3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS_LOCATION);
            GuiSliderHue.drawContinuousTexturedBox(this.x + (int)(this.sliderValue * (double)(this.width - 8)), this.y, 0, 66, 8, this.height, 200, 20, 2, 3, 2, 2, this.blitOffset);
        }
    }

    public void updateSlider() {
        super.updateSlider();
        if (this.drawString) {
            String val = Integer.toString(this.getValueInt());
            this.setMessage(this.dispString + val + this.suffix);
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public int getValueInt() {
        return (int)(this.minValue + (this.maxValue - this.minValue) * this.sliderValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public static void drawContinuousTexturedBox(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)leftBorder, (int)topBorder, (float)zLevel);
        GuiUtils.drawTexturedModalRect((int)(x + leftBorder + canvasWidth), (int)y, (int)(u + leftBorder + fillerWidth), (int)v, (int)rightBorder, (int)topBorder, (float)zLevel);
        GuiUtils.drawTexturedModalRect((int)x, (int)(y + topBorder + canvasHeight), (int)u, (int)(v + topBorder + fillerHeight), (int)leftBorder, (int)bottomBorder, (float)zLevel);
        GuiUtils.drawTexturedModalRect((int)(x + leftBorder + canvasWidth), (int)(y + topBorder + canvasHeight), (int)(u + leftBorder + fillerWidth), (int)(v + topBorder + fillerHeight), (int)rightBorder, (int)bottomBorder, (float)zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect((int)(x + leftBorder + i * fillerWidth), (int)y, (int)(u + leftBorder), (int)v, (int)(i == xPasses ? remainderWidth : fillerWidth), (int)topBorder, (float)zLevel);
            GuiUtils.drawTexturedModalRect((int)(x + leftBorder + i * fillerWidth), (int)(y + topBorder + canvasHeight), (int)(u + leftBorder), (int)(v + topBorder + fillerHeight), (int)(i == xPasses ? remainderWidth : fillerWidth), (int)bottomBorder, (float)zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect((int)(x + leftBorder + i * fillerWidth), (int)(y + topBorder + j * fillerHeight), (int)(u + leftBorder), (int)(v + topBorder), (int)(i == xPasses ? remainderWidth : fillerWidth), (int)(j == yPasses ? remainderHeight : fillerHeight), (float)zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect((int)x, (int)(y + topBorder + j * fillerHeight), (int)u, (int)(v + topBorder), (int)leftBorder, (int)(j == yPasses ? remainderHeight : fillerHeight), (float)zLevel);
            GuiUtils.drawTexturedModalRect((int)(x + leftBorder + canvasWidth), (int)(y + topBorder + j * fillerHeight), (int)(u + leftBorder + fillerWidth), (int)(v + topBorder), (int)rightBorder, (int)(j == yPasses ? remainderHeight : fillerHeight), (float)zLevel);
        }
    }
}

