/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fluids.FluidStack;
import shadows.compatched.block.BlockBarrel;
import shadows.compatched.tileentity.TileEntityBarrelFluid;

public class TileEntityBarrelFluidRenderer
extends TileEntityRenderer<TileEntityBarrelFluid> {
    public static final ResourceLocation blockSheet = new ResourceLocation("textures/atlas/blocks.png");

    public void render(TileEntityBarrelFluid te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te == null) {
            return;
        }
        FluidStack stack = te.tank.getFluid();
        if (!stack.isEmpty()) {
            TextureAtlasSprite tex = Minecraft.func_71410_x().func_147117_R().func_110572_b(stack.getFluid().getAttributes().getStillTexture().toString());
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            this.func_147499_a(blockSheet);
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)y, (double)z);
            GlStateManager.disableLighting();
            int color = stack.getFluid().getAttributes().getColor((IEnviromentBlockReader)te.func_145831_w(), te.func_174877_v());
            if (stack.getFluid() == Fluids.field_204546_a) {
                color = BiomeColors.func_217612_c((IEnviromentBlockReader)te.func_145831_w(), (BlockPos)te.func_174877_v());
            }
            if (color != -1) {
                float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
                GlStateManager.color3f((float)colors[0], (float)colors[1], (float)colors[2]);
            }
            double px = 0.0625;
            double minXZ = px * 3.0;
            double maxXZ = px * 13.0;
            double baseHeight = px;
            double height = px * 14.0 / (double)te.tank.getCapacity() * (double)te.tank.getFluidAmount() + baseHeight;
            double minU = tex.func_94214_a(3.0);
            double maxU = tex.func_94214_a(13.0);
            double minV = tex.func_94207_b(3.0);
            double maxV = tex.func_94207_b(13.0);
            double minV_side = tex.func_94207_b(0.0);
            double maxV_side = tex.func_94207_b((double)te.tank.getFluidAmount() * 16.0 / (double)te.tank.getCapacity());
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_181662_b(maxXZ, height, maxXZ).func_187315_a(maxU, maxV).func_181675_d();
            builder.func_181662_b(maxXZ, height, minXZ).func_187315_a(maxU, minV).func_181675_d();
            builder.func_181662_b(minXZ, height, minXZ).func_187315_a(minU, minV).func_181675_d();
            builder.func_181662_b(minXZ, height, maxXZ).func_187315_a(minU, maxV).func_181675_d();
            builder.func_181662_b(minXZ, baseHeight, maxXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b(minXZ, height, maxXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b(minXZ, height, minXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b(minXZ, baseHeight, minXZ).func_187315_a(minU, maxV_side).func_181675_d();
            builder.func_181662_b(maxXZ, baseHeight, minXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b(maxXZ, height, minXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b(maxXZ, height, maxXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b(maxXZ, baseHeight, maxXZ).func_187315_a(minU, maxV_side).func_181675_d();
            builder.func_181662_b(minXZ, baseHeight, minXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b(minXZ, height, minXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b(maxXZ, height, minXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b(maxXZ, baseHeight, minXZ).func_187315_a(minU, maxV_side).func_181675_d();
            builder.func_181662_b(maxXZ, baseHeight, maxXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b(maxXZ, height, maxXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b(minXZ, height, maxXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b(minXZ, baseHeight, maxXZ).func_187315_a(minU, maxV_side).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            float scale = 0.01f;
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            Direction facing = (Direction)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockBarrel.field_185512_D);
            GlStateManager.translatef((float)0.0f, (float)0.5001f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)facing.func_185119_l(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            FontRenderer fontrenderer = this.func_147498_b();
            int b0 = 0;
            String s = te.getText();
            fontrenderer.func_211126_b(s, (float)(-fontrenderer.func_78256_a(s) / 2), -5.0f, b0);
            GlStateManager.popMatrix();
        }
    }
}

