/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import shadows.compatched.CompactRegistry;
import shadows.compatched.inventory.IChest;
import shadows.compatched.inventory.InventoryBackpack;
import shadows.compatched.inventory.slot.SlotImmovable;
import shadows.compatched.tileentity.TileEntityChest;

public class ContainerChest
extends Container {
    public World world;
    public PlayerEntity player;
    public BlockPos pos;
    public IChest chest;
    public int invX;
    public int invY;
    public int lastId;
    public int backpackSlot;
    public int xSize;
    public int ySize;

    public ContainerChest(int id, World world, IChest chest, PlayerEntity player, BlockPos pos) {
        super(CompactRegistry.CHEST_CONTAINER, id);
        this.world = world;
        this.player = player;
        this.pos = pos;
        this.chest = chest;
        chest.onOpened(player);
        this.backpackSlot = -1;
        if (chest instanceof InventoryBackpack) {
            this.backpackSlot = ((InventoryBackpack)chest).slot;
        }
        this.invX = chest.getInvX();
        this.invY = chest.getInvY();
        this.xSize = 7 + (this.invX < 9 ? 162 : this.invX * 18) + 7;
        this.ySize = 15 + this.invY * 18 + 13 + 54 + 4 + 18 + 7;
        this.setupSlots();
    }

    public ContainerChest(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv.field_70458_d.field_70170_p, ContainerChest.readChest(buf, inv), inv.field_70458_d, buf.func_179259_c());
    }

    public static IChest readChest(PacketBuffer buf, PlayerInventory inv) {
        boolean chest = buf.readBoolean();
        if (chest) {
            return (IChest)inv.field_70458_d.field_70170_p.func_175625_s(buf.func_179259_c());
        }
        int slot = buf.readInt();
        return new InventoryBackpack(inv.func_70301_a(slot), slot);
    }

    public static PacketBuffer writeChest(PacketBuffer buf, IChest chest) {
        buf.writeBoolean(chest instanceof TileEntityChest);
        if (chest instanceof TileEntityChest) {
            buf.func_179255_a(((TileEntityChest)chest).func_174877_v());
        } else {
            buf.writeInt(((InventoryBackpack)chest).slot);
        }
        return buf;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    private void setupSlots() {
        Slot slot;
        int x;
        int slotX = this.xSize / 2 - this.invX * 18 / 2 + 1;
        int slotY = 18;
        int lastId = 0;
        for (int y = 0; y < this.invY; ++y) {
            for (int x2 = 0; x2 < this.invX; ++x2) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.chest.getItems(), lastId++, slotX + x2 * 18, slotY + y * 18));
            }
        }
        this.lastId = lastId;
        slotX = this.xSize / 2 - 81 + 1;
        slotY = slotY + this.invY * 18 + 13;
        for (x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                slot = new Slot((IInventory)this.player.field_71071_by, x + y * 9 + 9, slotX + x * 18, slotY + y * 18);
                this.func_75146_a(slot);
            }
        }
        slotY = slotY + 54 + 4;
        for (x = 0; x < 9; ++x) {
            boolean immovable = false;
            if (this.backpackSlot != -1 && this.backpackSlot == x) {
                immovable = true;
            }
            slot = new SlotImmovable((IInventory)this.player.field_71071_by, x, slotX + x * 18, slotY, immovable);
            this.func_75146_a(slot);
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        try {
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemStack1 = slot.func_75211_c();
                ItemStack itemStack = itemStack1.func_77946_l();
                if (slotIndex < this.lastId ? !this.func_75135_a(itemStack1, this.lastId, this.lastId + 36, false) : !this.func_75135_a(itemStack1, 0, this.lastId, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemStack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                return itemStack;
            }
            return ItemStack.field_190927_a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public int getInvX() {
        return this.invX;
    }

    public int getInvY() {
        return this.invY;
    }

    public void func_75134_a(PlayerEntity player) {
        boolean isChest;
        this.chest.onClosed(player);
        if (!this.world.field_72995_K && !(isChest = this.chest instanceof TileEntityChest)) {
            this.world.func_184148_a(null, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, SoundEvents.field_187554_ai, SoundCategory.BLOCKS, 0.5f, this.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        super.func_75134_a(player);
    }

    public ItemStack func_184996_a(int slot, int button, ClickType flag, PlayerEntity player) {
        if (this.chest instanceof InventoryBackpack && slot >= 0 && this.func_75139_a(slot).func_75211_c() == player.func_184586_b(Hand.MAIN_HAND)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, button, flag, player);
    }
}

