/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import shadows.compatched.CompactRegistry;
import shadows.compatched.inventory.slot.SlotUnplaceable;
import shadows.compatched.tileentity.TileEntityChestBuilder;
import shadows.compatched.util.StorageInfo;

public class ContainerChestBuilder
extends Container {
    public World world;
    public PlayerEntity player;
    public BlockPos pos;
    public TileEntityChestBuilder builder;
    public int xSize;

    public ContainerChestBuilder(int id, World world, PlayerEntity player, TileEntityChestBuilder te) {
        super(CompactRegistry.BUILDER_CONTAINER, id);
        this.world = world;
        this.player = player;
        this.pos = te.func_174877_v();
        this.builder = te;
        this.xSize = 176;
        this.setupSlots();
    }

    public ContainerChestBuilder(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv.field_70458_d.field_70170_p, inv.field_70458_d, (TileEntityChestBuilder)inv.field_70458_d.field_70170_p.func_175625_s(buf.func_179259_c()));
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return true;
    }

    private void setupSlots() {
        int x;
        int slotY = 62;
        int slotX = this.xSize / 2 - 36;
        for (int x2 = 0; x2 < 4; ++x2) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.builder.getItems(), x2, slotX + x2 * 18 + 1, slotY + 21));
        }
        SlotUnplaceable chestSlot = new SlotUnplaceable(this.builder.getItems(), 4, 5 + this.xSize - 29, 104);
        this.func_75146_a((Slot)chestSlot);
        slotX = this.xSize / 2 - 81 + 1;
        slotY = 126;
        for (x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                Slot slot = new Slot((IInventory)this.player.field_71071_by, x + y * 9 + 9, slotX + x * 18, slotY + y * 18);
                this.func_75146_a(slot);
            }
        }
        slotY = slotY + 54 + 4;
        for (x = 0; x < 9; ++x) {
            Slot slot = new Slot((IInventory)this.player.field_71071_by, x, slotX + x * 18, slotY);
            this.func_75146_a(slot);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        try {
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemStack1 = slot.func_75211_c();
                ItemStack itemStack = itemStack1.func_77946_l();
                if (slotIndex < 5 ? !this.func_75135_a(itemStack1, 5, 41, false) : !this.func_75135_a(itemStack1, 0, 5, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemStack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                return itemStack;
            }
            return ItemStack.field_190927_a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, 9);
        listener.func_71112_a((Container)this, 1, 3);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener player : this.field_75149_d) {
            if (this.builder == null) continue;
            StorageInfo info = this.builder.getInfo();
            player.func_71112_a((Container)this, 0, info.getSizeX());
            player.func_71112_a((Container)this, 1, info.getSizeY());
            player.func_71112_a((Container)this, 2, info.getHue());
            player.func_71112_a((Container)this, 3, info.getType().ordinal());
        }
    }

    public void func_75137_b(int id, int value) {
        switch (id) {
            case 0: {
                this.builder.getInfo().setSizeX(value);
                break;
            }
            case 1: {
                this.builder.getInfo().setSizeY(value);
                break;
            }
            case 2: {
                this.builder.getInfo().setHue(value);
                break;
            }
            case 3: {
                this.builder.getInfo().setType(StorageInfo.Type.values()[value]);
            }
        }
    }
}

