/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import shadows.compatched.inventory.ContainerChestBuilder;
import shadows.compatched.tileentity.TileEntityChest;
import shadows.compatched.tileentity.TileEntityChestBuilder;
import shadows.compatched.util.StorageInfo;
import shadows.placebo.util.NetworkUtils;

public class MessageCraftChest
extends NetworkUtils.MessageProvider<MessageCraftChest> {
    protected int x;
    protected int y;
    protected int z;
    protected StorageInfo info;

    public MessageCraftChest(int x, int y, int z, StorageInfo info) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.info = info;
    }

    public MessageCraftChest(BlockPos pos, StorageInfo info) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), info);
    }

    public MessageCraftChest() {
    }

    public Class<MessageCraftChest> getMsgClass() {
        return MessageCraftChest.class;
    }

    public MessageCraftChest read(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.info = new StorageInfo(buf.readInt(), buf.readInt(), buf.readInt(), StorageInfo.Type.values()[buf.readInt()]);
        return new MessageCraftChest(this.x, this.y, this.z, this.info);
    }

    public void write(MessageCraftChest msg, PacketBuffer buf) {
        buf.writeInt(msg.x);
        buf.writeInt(msg.y);
        buf.writeInt(msg.z);
        buf.writeInt(msg.info.getSizeX());
        buf.writeInt(msg.info.getSizeY());
        buf.writeInt(msg.info.getHue());
        buf.writeInt(msg.info.getType().ordinal());
    }

    public void handle(MessageCraftChest msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtils.handlePacket(() -> () -> MessageCraftChest.lambda$null$0((Supplier)ctx, msg), (NetworkEvent.Context)ctx.get());
    }

    private static /* synthetic */ void lambda$null$0(Supplier ctx, MessageCraftChest msg) {
        ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
        TileEntityChestBuilder builder = null;
        if (player.field_71070_bA instanceof ContainerChestBuilder) {
            builder = ((ContainerChestBuilder)player.field_71070_bA).builder;
        }
        if (builder == null) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            items.add(builder.getItems().getStackInSlot(i));
        }
        List<ItemStack> requiredItems = builder.getInfo().getMaterialCost();
        boolean hasRequiredMaterials = true;
        for (int slot = 0; slot < items.size(); ++slot) {
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack != null && slot < requiredItems.size() && requiredItems.get(slot) != null) {
                if (requiredItems.get(slot).func_77973_b() != stack.func_77973_b() || stack.func_190916_E() < requiredItems.get(slot).func_190916_E()) {
                    hasRequiredMaterials = requiredItems.get(slot) != null && requiredItems.get(slot).func_190916_E() == 0;
                    break;
                }
            } else {
                hasRequiredMaterials = false;
                break;
            }
            hasRequiredMaterials = true;
        }
        if (hasRequiredMaterials && builder.getItems().getStackInSlot(4).func_190926_b()) {
            ItemStack stack = msg.info.getType().display.func_77946_l();
            TileEntityChest chest = new TileEntityChest(msg.info);
            chest.func_189515_b(stack.func_190925_c("BlockEntityTag"));
            builder.getItems().setStackInSlot(4, stack);
            for (int x = 0; x < requiredItems.size(); ++x) {
                builder.getItems().getStackInSlot(x).func_190918_g(requiredItems.get(x).func_190916_E());
            }
            player.field_70170_p.func_184133_a(null, builder.func_174877_v(), SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, builder.func_174877_v(), SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 1.0f, 0.0f);
        }
    }
}

