/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.tileentity;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import shadows.compatched.CompactRegistry;
import shadows.compatched.inventory.BarrelItemHandler;
import shadows.compatched.tileentity.IBarrel;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public class TileEntityBarrel
extends TileEntity
implements IBarrel {
    protected ItemStack item = ItemStack.field_190927_a;
    protected int count = 0;
    protected BarrelItemHandler handler = new BarrelItemHandler(this);
    public int hue = 128;
    LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> this.handler);

    public TileEntityBarrel() {
        super(CompactRegistry.BARREL_TILE);
    }

    @Override
    public ItemStack giveItems(PlayerEntity player) {
        ItemStack stack = this.tryTakeStack(player, this.item.func_77976_d(), false);
        return stack;
    }

    @Override
    public ItemStack takeItems(ItemStack stack, PlayerEntity player) {
        return this.insertItems(stack, player, false);
    }

    public ItemStack tryTakeStack(PlayerEntity player, int amount, boolean simulate) {
        if (this.count > 0) {
            ItemStack stack = this.item.func_77946_l();
            stack.func_190920_e(Math.min(this.count, Math.min(stack.func_77976_d(), amount)));
            if (!simulate) {
                this.count -= stack.func_190916_E();
                if (this.count <= 0) {
                    this.count = 0;
                    this.item = ItemStack.field_190927_a;
                }
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItems(ItemStack stack, PlayerEntity player, boolean simulate) {
        ItemStack workingStack = stack.func_77946_l();
        if (workingStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.item.func_190926_b()) {
            if (!simulate) {
                this.item = workingStack.func_77946_l();
                this.count = this.item.func_190916_E();
                this.item.func_190920_e(1);
                this.func_70296_d();
            }
            return ItemStack.field_190927_a;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.item, (ItemStack)workingStack) && this.count < this.getMaxStorage()) {
            int used = Math.min(workingStack.func_190916_E(), this.getMaxStorage() - this.count);
            if (!simulate) {
                this.count += used;
                this.func_70296_d();
            }
            workingStack.func_190918_g(used);
            return workingStack;
        }
        return workingStack;
    }

    @Override
    public int color() {
        return this.hue;
    }

    public String getText() {
        if (this.item.func_190926_b()) {
            return "Empty";
        }
        if (this.count < this.item.func_77976_d()) {
            return this.count + "";
        }
        int numOfStacks = this.count / this.item.func_77976_d();
        return numOfStacks + "x" + this.item.func_77976_d();
    }

    public int getMaxStorage() {
        return this.item.func_77976_d() * 64;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("item", (INBT)this.item.func_77955_b(new CompoundNBT()));
        compound.func_74768_a("count", this.count);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.item = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item"));
        this.count = compound.func_74762_e("count");
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = this.func_189515_b(new CompoundNBT());
        CompoundNBT item = this.item.func_77973_b().getShareTag(this.item);
        if (this.item.func_77942_o()) {
            tag.func_74775_l("item").func_218657_a("tag", (INBT)item);
        }
        return tag;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getBarrelStack() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }
}

