/*
 * Decompiled with CFR 0.152.
 */
package shadows.compatched.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import shadows.compatched.CompactRegistry;
import shadows.compatched.tileentity.IBarrel;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public class TileEntityBarrelFluid
extends TileEntity
implements IBarrel,
ITickableTileEntity {
    public FluidTank tank = new FluidTank(32000);
    public int hue = 128;
    public int lastAmount;
    LazyOptional<IFluidHandler> fluidOpt = LazyOptional.of(() -> this.tank);

    public TileEntityBarrelFluid() {
        super(CompactRegistry.FLUID_BARREL_TILE);
    }

    @Override
    public ItemStack giveItems(PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack takeItems(@Nonnull ItemStack stack, PlayerEntity player) {
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)this.tank, null, (int)this.tank.getCapacity(), (PlayerEntity)player, (boolean)true);
        if (res.isSuccess()) {
            return res.result;
        }
        res = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)this.tank, null, (int)this.tank.getCapacity(), (PlayerEntity)player, (boolean)true);
        if (res.isSuccess()) {
            return res.result;
        }
        return stack;
    }

    @Override
    public int color() {
        return this.hue;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("fluid", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        compound.func_74768_a("hue", this.hue);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.tank.readFromNBT(compound.func_74775_l("fluid"));
        this.hue = compound.func_74762_e("hue");
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("fluid", (INBT)this.tank.getFluid().writeToNBT(new CompoundNBT()));
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.tank.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)pkt.func_148857_g().func_74775_l("fluid")));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.lastAmount != this.tank.getFluidAmount()) {
            this.func_70296_d();
        }
        this.lastAmount = this.tank.getFluid().isEmpty() ? 0 : this.tank.getFluidAmount();
    }

    public String getText() {
        if (this.tank.getFluid().isEmpty() || this.tank.getFluidAmount() == 0) {
            return I18n.func_135052_a((String)"compatchedstorage.text.empty", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"compatchedstorage.text.fluidformat", (Object[])new Object[]{this.tank.getFluidAmount(), 32000});
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }
}

